package cn.wumoe.hime.module

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import cn.wumoe.hime.toWord
import java.util.*
import javax.crypto.Cipher
import javax.crypto.spec.SecretKeySpec

class AESModule : Module("hime.aes") {
    override fun init(context: HimeContext) {
        addFunction(Encrypt())  // aes-encrypt
        addFunction(Decrypt())  // aes-decrypt
    }

    class Encrypt : Function("aes-encrypt") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.size >= 2) {
                val cipher = Cipher.getInstance("AES/ECB/PKCS5Padding")
                cipher.init(Cipher.ENCRYPT_MODE, SecretKeySpec(pars[0].toString().toByteArray(), "AES"))
                String(Base64.getEncoder().encode(cipher.doFinal(pars[1].toString().toByteArray()))).toWord()
            } else
                Word.NIL
        }
    }

    class Decrypt : Function("aes-decrypt") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.size >= 2) {
                val cipher = Cipher.getInstance("AES/ECB/PKCS5Padding")
                cipher.init(Cipher.DECRYPT_MODE, SecretKeySpec(pars[0].toString().toByteArray(), "AES"))
                String(cipher.doFinal(Base64.getDecoder().decode(pars[1].toString().toByteArray()))).toWord()
            } else
                Word.NIL
        }
    }
}