package cn.wumoe.hime.gui;

import org.fife.ui.rsyntaxtextarea.AbstractTokenMaker;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMap;

import javax.swing.text.Segment;

public class HimeTokenMaker extends AbstractTokenMaker {
    public static TokenMap tokenMap;
    private static final String OPERATORS = "=|><&";
    private static final String SEPARATORS = "()[]";
    private static final String SEPARATORS2 = ".,;";
    private static final String shellVariables = "#-?$!*@_";

    @Override
    public TokenMap getWordsToHighlight() {
        tokenMap = new TokenMap();
        tokenMap.put("nil", Token.RESERVED_WORD);
        tokenMap.put("else", Token.RESERVED_WORD);
        tokenMap.put("true", Token.RESERVED_WORD);
        tokenMap.put("false", Token.RESERVED_WORD);
        return tokenMap;
    }

    @Override
    public void addToken(Segment segment, int start, int end, int tokenType, int startOffset) {
        int value = wordsToHighlight.get(segment, start, end);
        if (value != -1)
            tokenType = value;
        super.addToken(segment, start, end, tokenType, startOffset);
    }

    public Token getTokenList(Segment text, int startTokenType, int startOffset) {
        resetTokenList();
        char[] array = text.array;
        int offset = text.offset;
        int count = text.count;
        int end = offset + count;
        int newStartOffset = startOffset - offset;
        int currentTokenStart = offset;
        int currentTokenType = startTokenType;
        boolean backslash = false;
        for (int i = offset; i < end; ++i) {
            char c = array[i];
            switch (currentTokenType) {
                case Token.NULL:
                    currentTokenStart = i;
                    switch (c) {
                        case ' ':
                        case '\t':
                            currentTokenType = Token.WHITESPACE;
                            break;
                        case '"':
                            if (backslash) {
                                addToken(text, currentTokenStart, i, Token.IDENTIFIER, newStartOffset + currentTokenStart);
                                backslash = false;
                            } else
                                currentTokenType = Token.LITERAL_STRING_DOUBLE_QUOTE;
                            break;
                        case '\\':
                            addToken(text, currentTokenStart, i, Token.IDENTIFIER, newStartOffset + currentTokenStart);
                            backslash = !backslash;
                            break;
                        case ';':
                            backslash = false;
                            currentTokenType = Token.COMMENT_EOL;
                            break;
                        default:
                            if (RSyntaxUtilities.isDigit(c)) {
                                currentTokenType = Token.LITERAL_NUMBER_DECIMAL_INT;
                                break;
                            } else if (RSyntaxUtilities.isLetter(c) || c == '/' || c == '_') {
                                currentTokenType = Token.IDENTIFIER;
                                break;
                            }
                            int indexOf = OPERATORS.indexOf(c);
                            if (indexOf > -1) {
                                addToken(text, currentTokenStart, i, Token.OPERATOR, newStartOffset + currentTokenStart);
                                break;
                            }
                            indexOf = SEPARATORS.indexOf(c);
                            if (indexOf > -1) {
                                addToken(text, currentTokenStart, i, Token.SEPARATOR, newStartOffset + currentTokenStart);
                                break;
                            }
                            indexOf = SEPARATORS2.indexOf(c);
                            if (indexOf > -1)
                                addToken(text, currentTokenStart, i, Token.IDENTIFIER, newStartOffset + currentTokenStart);
                            else
                                currentTokenType = Token.IDENTIFIER;
                            break;
                    }
                    break;
                case Token.WHITESPACE:
                    switch (c) {
                        case ' ':
                        case '\t':
                            break;
                        case '\\':
                            addToken(text, currentTokenStart, i - 1, Token.WHITESPACE, newStartOffset + currentTokenStart);
                            addToken(text, i, i, Token.IDENTIFIER, newStartOffset + i);
                            currentTokenType = Token.NULL;
                            backslash = true;
                            break;
                        case '"':
                            addToken(text, currentTokenStart, i - 1, Token.WHITESPACE, newStartOffset + currentTokenStart);
                            currentTokenStart = i;
                            currentTokenType = Token.LITERAL_STRING_DOUBLE_QUOTE;
                            backslash = false;
                            break;
                        case ';':
                            addToken(text, currentTokenStart,i-1, Token.WHITESPACE, newStartOffset+currentTokenStart);
                            currentTokenStart = i;
                            currentTokenType = Token.COMMENT_EOL;
                            break;
                        default:
                            addToken(text, currentTokenStart, i - 1, Token.WHITESPACE, newStartOffset + currentTokenStart);
                            currentTokenStart = i;
                            if (RSyntaxUtilities.isDigit(c)) {
                                currentTokenType = Token.LITERAL_NUMBER_DECIMAL_INT;
                                break;
                            }
                            int indexOf = OPERATORS.indexOf(c);
                            if (indexOf > -1) {
                                addToken(text, i, i, Token.OPERATOR, newStartOffset + i);
                                currentTokenType = Token.NULL;
                                break;
                            }
                            indexOf = SEPARATORS.indexOf(c);
                            if (indexOf > -1) {
                                addToken(text, i, i, Token.SEPARATOR, newStartOffset + i);
                                currentTokenType = Token.NULL;
                                break;
                            }
                            indexOf = SEPARATORS2.indexOf(c);
                            if (indexOf > -1) {
                                addToken(text, i, i, Token.IDENTIFIER, newStartOffset + i);
                                currentTokenType = Token.NULL;
                                break;
                            } else
                                currentTokenType = Token.IDENTIFIER;
                    }
                    break;
                default:
                case Token.IDENTIFIER:
                    switch (c) {
                        case ' ':
                        case '\t':
                            addToken(text, currentTokenStart, i - 1, Token.IDENTIFIER, newStartOffset + currentTokenStart);
                            currentTokenStart = i;
                            currentTokenType = Token.WHITESPACE;
                            break;
                        case '"':
                            addToken(text, currentTokenStart, i - 1, Token.IDENTIFIER, newStartOffset + currentTokenStart);
                            currentTokenStart = i;
                            currentTokenType = Token.LITERAL_STRING_DOUBLE_QUOTE;
                            backslash = false;
                            break;
                        case '\\':
                            addToken(text, currentTokenStart, i - 1, Token.IDENTIFIER, newStartOffset + currentTokenStart);
                            addToken(text, i, i, Token.IDENTIFIER, newStartOffset + i);
                            currentTokenType = Token.NULL;
                            backslash = true;
                        default:
                            if (RSyntaxUtilities.isLetterOrDigit(c) || c == '_')
                                break;
                            int indexOf = OPERATORS.indexOf(c);
                            if (indexOf > -1) {
                                addToken(text, currentTokenStart, i - 1, Token.IDENTIFIER, newStartOffset + currentTokenStart);
                                addToken(text, i, i, Token.OPERATOR, newStartOffset + i);
                                currentTokenType = Token.NULL;
                                break;
                            }
                            indexOf = SEPARATORS.indexOf(c);
                            if (indexOf > -1) {
                                addToken(text, currentTokenStart, i - 1, Token.IDENTIFIER, newStartOffset + currentTokenStart);
                                addToken(text, i, i, Token.SEPARATOR, newStartOffset + i);
                                currentTokenType = Token.NULL;
                                break;
                            }
                            indexOf = SEPARATORS2.indexOf(c);
                            if (indexOf > -1) {
                                addToken(text, currentTokenStart, i - 1, Token.IDENTIFIER, newStartOffset + currentTokenStart);
                                addToken(text, i, i, Token.IDENTIFIER, newStartOffset + i);
                                currentTokenType = Token.NULL;
                                break;
                            }
                    }
                    break;
                case Token.LITERAL_NUMBER_DECIMAL_INT:
                    switch (c) {
                        case ' ':
                        case '\t':
                            addToken(text, currentTokenStart, i - 1, Token.LITERAL_NUMBER_DECIMAL_INT, newStartOffset + currentTokenStart);
                            currentTokenStart = i;
                            currentTokenType = Token.WHITESPACE;
                            break;

                        case '"':
                            addToken(text, currentTokenStart, i - 1, Token.LITERAL_NUMBER_DECIMAL_INT, newStartOffset + currentTokenStart);
                            currentTokenStart = i;
                            currentTokenType = Token.LITERAL_STRING_DOUBLE_QUOTE;
                            backslash = false;
                            break;
                        default:
                            if (RSyntaxUtilities.isDigit(c))
                                break;
                            int indexOf = OPERATORS.indexOf(c);
                            if (indexOf > -1) {
                                addToken(text, currentTokenStart, i - 1, Token.LITERAL_NUMBER_DECIMAL_INT, newStartOffset + currentTokenStart);
                                addToken(text, i, i, Token.OPERATOR, newStartOffset + i);
                                currentTokenType = Token.NULL;
                                break;
                            }
                            indexOf = SEPARATORS.indexOf(c);
                            if (indexOf > -1) {
                                addToken(text, currentTokenStart, i - 1, Token.LITERAL_NUMBER_DECIMAL_INT, newStartOffset + currentTokenStart);
                                addToken(text, i, i, Token.SEPARATOR, newStartOffset + i);
                                currentTokenType = Token.NULL;
                                break;
                            }
                            indexOf = SEPARATORS2.indexOf(c);
                            if (indexOf > -1) {
                                addToken(text, currentTokenStart, i - 1, Token.LITERAL_NUMBER_DECIMAL_INT, newStartOffset + currentTokenStart);
                                addToken(text, i, i, Token.IDENTIFIER, newStartOffset + i);
                                currentTokenType = Token.NULL;
                                break;
                            }
                            addToken(text, currentTokenStart, i - 1, Token.LITERAL_NUMBER_DECIMAL_INT, newStartOffset + currentTokenStart);
                            i--;
                            currentTokenType = Token.NULL;
                    }
                    break;
                case Token.VARIABLE:
                    while (i < end) {
                        c = array[i];
                        if (!RSyntaxUtilities.isLetterOrDigit(c) && shellVariables.indexOf(c) == -1 && c != '_') {
                            addToken(text, currentTokenStart, i - 1, Token.VARIABLE, newStartOffset + currentTokenStart);
                            i--;
                            currentTokenType = Token.NULL;
                            break;
                        }
                        i++;
                    }
                    if (i == end) {
                        addToken(text, currentTokenStart, i - 1, Token.VARIABLE, newStartOffset + currentTokenStart);
                        currentTokenType = Token.NULL;
                    }
                    break;
                case Token.COMMENT_EOL:
                    i = end - 1;
                    addToken(text, currentTokenStart,i, currentTokenType, newStartOffset+currentTokenStart);
                    currentTokenType = Token.NULL;
                    break;
                case Token.LITERAL_CHAR:
                    if (c == '\\')
                        backslash = !backslash;
                    break;
                case Token.LITERAL_STRING_DOUBLE_QUOTE:
                    switch (c) {
                        case '\\':
                            backslash = !backslash;
                            break;

                        case '"':
                            if (!backslash) {
                                addToken(text, currentTokenStart, i, Token.LITERAL_STRING_DOUBLE_QUOTE, newStartOffset + currentTokenStart);
                                currentTokenType = Token.NULL;
                                // backslash is definitely false when we leave.
                                break;
                            }
                            backslash = false;
                            break;
                        default:
                            backslash = false;
                    }
                    break;
            }
        }
        switch (currentTokenType) {
            case Token.LITERAL_BACKQUOTE:
            case Token.LITERAL_STRING_DOUBLE_QUOTE:
            case Token.LITERAL_CHAR:
                addToken(text, currentTokenStart, end - 1, currentTokenType, newStartOffset + currentTokenStart);
                break;
            case Token.NULL:
                addNullToken();
                break;
            default:
                addToken(text, currentTokenStart, end - 1, currentTokenType, newStartOffset + currentTokenStart);
                addNullToken();
        }
        return firstToken;

    }
}