package cn.wumoe.hime.gui;

import cn.wumoe.hime.Config;

import cn.wumoe.hime.module.KeyModule;
import org.fife.ui.rsyntaxtextarea.*;
import org.fife.ui.rsyntaxtextarea.folding.FoldParserManager;
import org.fife.ui.rtextarea.RTextScrollPane;

import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.concurrent.atomic.AtomicInteger;

public class GUI extends JFrame {
    public static AtomicInteger flag = new AtomicInteger(0);
    public static AtomicInteger lineFlag = new AtomicInteger(0);
    public static int length = 0;
    public static ScriptEngine engine;
    public static String copy;
    public static Thread thread;
    public static void main(String[] args) {
        Config.GUI = true;
        JFrame jFrame = new JFrame("Press Ctrl + R to execute.");
        jFrame.addWindowListener(new WindowListener() {
            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                KeyModule.Companion.getProvider().reset();
                KeyModule.Companion.getProvider().stop();
            }

            @Override
            public void windowClosed(WindowEvent e) {

            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {

            }

            @Override
            public void windowActivated(WindowEvent e) {

            }

            @Override
            public void windowDeactivated(WindowEvent e) {

            }
        });
        int inset = 100;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (screenSize.width - inset * 5) / 2;
        int height = screenSize.height - inset * 2;

        JPanel panel = new JPanel(new FlowLayout());

        RSyntaxTextArea textArea = new RSyntaxTextArea();
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory) TokenMakerFactory.getDefaultInstance();
        atmf.putMapping("text/hime", "cn.wumoe.hime.gui.HimeTokenMaker");
        FoldParserManager.get().addFoldParserMapping("text/hime", new HimeFoldParser());
        textArea.setSyntaxEditingStyle("text/hime");
        textArea.setCodeFoldingEnabled(true);
        textArea.setAntiAliasingEnabled(true);

        SyntaxScheme scheme = textArea.getSyntaxScheme();
        scheme.getStyle(Token.FUNCTION).foreground = Color.blue;
        textArea.revalidate();

        textArea.setBounds(0, 0, width - (width / 12), height - (height / 3));
        textArea.setPreferredSize(new Dimension(width - (width / 12), height - (height / 3)));
        textArea.setFont(new Font(textArea.getFont().getName(), textArea.getFont().getStyle(), (height / 50)));

        RTextScrollPane sp = new RTextScrollPane(textArea);
        sp.setPreferredSize(new Dimension(width, height - (height / 3)));
        panel.add(sp);

        JTextArea result = new JTextArea();
        result.setLineWrap(true);
        result.setBounds(0, height - (height / 3), width, (height / 3) - 20);
        JScrollPane resultJsp = new JScrollPane(result, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        resultJsp.setPreferredSize(new Dimension(width, (height / 3) - 20));
        result.setFont(new Font(result.getFont().getName(), result.getFont().getStyle(), (height / 50)));
        panel.add(resultJsp);

        jFrame.setResizable(false);
        jFrame.add(panel);
        jFrame.setBounds(inset, inset, width + 18, height + 30);
        jFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        jFrame.setVisible(true);

        textArea.addKeyListener(new KeyAdapter() {
            @Override
            public void keyTyped(KeyEvent e) {
                String[] ss = textArea.getText().split("\n", -1);
                int size = ss.length;
                int widthMax = -1;
                for (String s : ss)
                    widthMax = Math.max(widthMax, s.length());
                textArea.setPreferredSize(new Dimension(Math.max(width - (width / 12), (width / 63) * widthMax), Math.max(height - (height / 3), ((height / 50) + (height / 190)) * size)));
            }
            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == KeyEvent.VK_R && ((event.getModifiersEx() & KeyEvent.CTRL_DOWN_MASK) != 0)) {
                    GUI.flag.set(0);
                    GUI.lineFlag.set(0);
                    GUI.length = 0;
                    GUI.copy = "";
                    result.setText("");
                    if (thread != null)
                        thread.interrupt();
                    thread = new Thread(() -> {
                        try {
                            engine = new ScriptEngineManager().getEngineByName("hime");
                            ScriptContext context = engine.getContext();
                            JTextAreaOutputStream out = new JTextAreaOutputStream(result);
                            context.setWriter(new PrintWriter(out));
                            engine.eval(textArea.getText());
                            engine = null;
                        } catch (ScriptException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    thread.start();
                }
            }
        });

        result.addKeyListener(new KeyAdapter() {
            @Override
            public void keyTyped(KeyEvent e) {
                if (result.getText().length() < GUI.length)
                    result.setText(copy);
            }

            @Override
            public void keyReleased(KeyEvent event) {
                if (event.getKeyCode() == KeyEvent.VK_R && ((event.getModifiersEx() & KeyEvent.CTRL_DOWN_MASK) != 0)) {
                    GUI.flag.set(0);
                    GUI.lineFlag.set(0);
                    GUI.length = 0;
                    GUI.copy = "";
                    result.setText("");
                    if (thread != null)
                        thread.interrupt();
                    thread = new Thread(() -> {
                        try {
                            engine = new ScriptEngineManager().getEngineByName("hime");
                            ScriptContext context = engine.getContext();
                            JTextAreaOutputStream out = new JTextAreaOutputStream(result);
                            context.setWriter(new PrintWriter(out));
                            engine.eval(textArea.getText());
                            engine = null;
                        } catch (ScriptException e) {
                            throw new RuntimeException(e);
                        }
                    });
                    thread.start();
                }
                if (event.getKeyCode() == KeyEvent.VK_ENTER && engine != null) {
                    engine.getContext().setReader(new StringReader(result.getText().substring(GUI.length)));
                    lineFlag.getAndIncrement();
                }
            }
        });
    }
}