package cn.wumoe.hime.api.scripting

import cn.wumoe.hime.Hime
import cn.wumoe.hime.cast
import cn.wumoe.hime.semantic.SymbolList
import cn.wumoe.hime.inter.ASTNode
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.semantic.Analysis
import java.io.Reader
import java.util.concurrent.ConcurrentHashMap
import javax.script.*

class HimeScriptEngine : ScriptEngine {
    private var context: HimeContext = HimeContext()
    override fun getContext() = context
    override fun setContext(context: ScriptContext) {
        if (context is HimeContext) this.context = context
    }

    override fun getFactory() = HimeScriptEngineFactory()
    override fun eval(script: String, context: ScriptContext): Token = eval(script, (context as HimeContext).bindings)
    override fun eval(script: String): Token = eval(script, context.bindings)
    override fun eval(reader: Reader): Token = eval(reader.readText(), context.bindings)
    override fun eval(reader: Reader, n: Bindings): Token = eval(reader.readText(), n)
    override fun eval(reader: Reader, context: ScriptContext): Token =
        eval(reader.readText(), (context as HimeContext).bindings)

    override fun eval(script: String, n: Bindings): Token = Hime(
        cast(n),
        context
    ).run(script)
    override fun get(key: String?): Any = context.bindings[key]
    override fun getBindings(scope: Int): Bindings = context.bindings

    override fun setBindings(bindings: Bindings?, scope: Int) {
        if (bindings is SymbolList) context.bindings = bindings
    }

    override fun createBindings(): Bindings =  SymbolList(
        ConcurrentHashMap(),
        ConcurrentHashMap(),
        ASTNode.EMPTY,
        null,
        Analysis()
    )

    override fun put(key: String, value: Any?) {
        context.bindings[key] = value
    }
}