package cn.wumoe.hime

import cn.wumoe.hime.lexer.*
import cn.wumoe.hime.lexer.Array
import java.math.BigDecimal
import java.math.BigInteger

fun BigInteger.toNum(): Num = Num.toNum(this)
fun Int.toNum(): Num = Num.toNum(this)
fun Long.toNum(): Num = Num.toNum(this)
fun BigDecimal.toReal(): Real = Real.toReal(this)
fun Double.toReal(): Real = Real.toReal(this)
fun Float.toReal(): Real = Real.toReal(this)
fun String.toWord(): Word = Word(this, Tag.STR)
fun Boolean.toBool(): Word = if (this) Word.True else Word.False

fun BigDecimal.simplification(): BigDecimal {
    if (this == BigDecimal.ZERO)
        return this
    var s = this.toPlainString()
    if (s.contains(".")) {
        for (i in s.length - 1 downTo 0) {
            if (!s.contains("."))
                break
            if (s[i] != '0' || s[i] != '.')
                break
            s = s.substring(0, i)
        }
    }
    return BigDecimal(s)
}

fun Any.toToken(): Token = when (this) {
    is Boolean -> if (this) Word.True else Word.False
    is Int -> Num.toNum(this)
    is Long -> Num.toNum(this)
    is BigInteger -> Num.toNum(this)
    is Double -> Real.toReal(this)
    is Float -> Real.toReal(this)
    is BigDecimal -> Real.toReal(this)
    is String -> this.toWord()
    is List<*> -> {
        val array = Array(ArrayList())
        for (v in this)
            array.add(v!!.toToken())
        array
    }
    else -> this.toString().toWord()
}

inline fun <reified R> cast(any: Any?) = any as? R ?: throw java.lang.RuntimeException("null is not ${R::class.java.name}")

inline fun forceRun(block: () -> Unit) {
    try {
        block()
    } catch (_: Throwable) {
    }
}
