package cn.wumoe.hime;

public class Format {
    public static String format(String s) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        char[] chars = s.replace("\r\n", "\n").replaceAll("(?m)^\\s*$\\n", "").toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (index >= 1 && c == '\"') {
                builder.append('\"');
                int j = i;
                boolean skip = false;
                while (true) {
                    char peek = chars[++j];
                    if ((chars[j + 1] == '\\' || chars[j + 1] == '\"') && peek == '\\') {
                        skip = !skip;
                    } else if (peek == '\"') {
                        if (!skip) {
                            break;
                        } else {
                            skip = false;
                        }
                    }
                    builder.append(peek);
                    ++i;
                }
                builder.append("\"");
                ++i;
            }else if (c == ';') {
                while (i < chars.length - 1 && chars[++i] != '\n');
            } else if (c == '(') {
                ++index;
                builder.append(c);
            } else if (c == ')') {
                --index;
                builder.append(c);
            } else if (index >= 1 && (c == ' ' || c == '\n' || c == '\t')) {
                int j = i + 1;
                while (chars[j] == ' ' || chars[j] == '\n' || chars[j] == '\t') {
                    ++i;
                    ++j;
                }
                builder.append(' ');
            } else
                builder.append(c);
        }
        return builder.toString();
    }
}
