package cn.wumoe.hime.module.properties

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import cn.wumoe.hime.toWord

class PropertiesModule : Module("hime.properties") {
    override fun init(himeContext: HimeContext) {
        addFunction(PropertiesLoad())   // properties-load
        addFunction(PropertiesGet())    // properties-get
        addFunction(PropertiesSet())    // properties-set
        addFunction(PropertiesKeys())   // properties-keys
        addFunction(PropertiesRemove()) // properties-remove
    }

    class PropertiesLoad : Function("properties-load") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty())
                PropertiesToken(pars[0].toString())
            else
                Word.NIL
        }
    }

    class PropertiesKeys : Function("properties-keys") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty() && pars[0] is PropertiesToken) {
                val keys = (pars[0] as PropertiesToken).keys()
                val array =
                    cn.wumoe.hime.lexer.Array(ArrayList<Token>())
                for (key in keys)
                    array.add(key.toString().toWord())
                array
            } else
                Word.NIL
        }
    }

    class PropertiesRemove : Function("properties-remove") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 2 && pars[0] is PropertiesToken)
                (pars[0] as PropertiesToken).remove(pars[1].toString())
            return Word.NIL
        }
    }

    class PropertiesGet : Function("properties-get") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.size >= 2 && pars[0] is PropertiesToken)
                (pars[0] as PropertiesToken)[pars[1].toString(), if(pars.size >= 3) pars[2].toString() else ""].toWord()
            else
                Word.NIL
        }
    }

    class PropertiesSet : Function("properties-set") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 3 && pars[0] is PropertiesToken)
                (pars[0] as PropertiesToken)[pars[1].toString(), pars[2].toString()] = if(pars.size >= 4) pars[3].toString() else ""
            return Word.NIL
        }
    }
}