package cn.wumoe.hime.module.http.server

import com.sun.net.httpserver.HttpExchange
import org.apache.commons.io.IOUtils
import java.net.URLDecoder
import java.nio.charset.StandardCharsets
import java.util.*

object HttpHandlerUtils {
    fun result(exchange: HttpExchange, rCode: Int, response: ByteArray) {
        exchange.sendResponseHeaders(rCode, response.size.toLong())
        exchange.responseBody.use { os -> os.write(response) }
    }

    fun result(exchange: HttpExchange, rCode: Int, response: String) {
        exchange.sendResponseHeaders(rCode, response.length.toLong())
        exchange.responseBody.use { os -> os.write(response.toByteArray(StandardCharsets.UTF_8)) }
    }

    fun getGet(exchange: HttpExchange): Map<String, String> {
        return formData2Dic(exchange.requestURI.query)
    }

    fun getPost(exchange: HttpExchange): Map<String, String> {
        return formData2Dic(IOUtils.toString(exchange.requestBody, StandardCharsets.UTF_8))
    }

    private fun formData2Dic(formData: String?): Map<String, String> {
        val result: MutableMap<String, String> = HashMap()
        if (formData == null || formData.trim { it <= ' ' }.isEmpty()) return result
        val items = formData.split("&".toRegex()).dropLastWhile { it.isEmpty() }.toTypedArray()
        Arrays.stream(items).forEach { item: String ->
            val keyAndVal = item.split("=".toRegex()).dropLastWhile { it.isEmpty() }.toTypedArray()
            if (keyAndVal.size == 2) {
                val key = URLDecoder.decode(keyAndVal[0], StandardCharsets.UTF_8)
                val `val` = URLDecoder.decode(keyAndVal[1], StandardCharsets.UTF_8)
                result[key] = `val`
            }
        }
        return result
    }
}