package cn.wumoe.hime.module.http

import java.io.*
import java.net.*
import java.nio.charset.StandardCharsets
import java.util.*

object HttpUtil {
    fun download(url: String, path: String) {
        var byteRead: Int
        val conn: URLConnection = URL(url).openConnection()
        val inStream: InputStream = conn.getInputStream()
        val fs = FileOutputStream(path)
        val buffer = ByteArray(1024)
        while (inStream.read(buffer).also { byteRead = it } != -1) {
            fs.write(buffer, 0, byteRead)
        }
    }

    fun get(url: String): String {
        val urlConnection = URL(url).openConnection()
        val br = BufferedReader(InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8))
        var line: String?
        val builder = StringBuilder()
        while (br.readLine().also { line = it } != null)
            builder.append(line).append("\n")
        br.close()
        return builder.toString()
    }

    fun post(url: String, parameterMap: Map<String, String>): String {
        val httpURLConnection = URL(url).openConnection() as HttpURLConnection
        httpURLConnection.doInput = true
        httpURLConnection.doOutput = true
        httpURLConnection.requestMethod = "POST"
        httpURLConnection.setRequestProperty("charset", "utf-8")
        val pw = PrintWriter(BufferedOutputStream(httpURLConnection.outputStream))
        val parameter = StringBuilder()
        for ((key, value) in parameterMap) parameter.append("&").append(URLEncoder.encode(key, StandardCharsets.UTF_8))
            .append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8))
        pw.write(parameter.toString())
        pw.flush()
        pw.close()
        val br = BufferedReader(InputStreamReader(httpURLConnection.inputStream, StandardCharsets.UTF_8))
        var line: String?
        val builder = StringBuilder()
        while (br.readLine().also { line = it } != null)
            builder.append(line).append("\n")
        br.close()
        return builder.toString()
    }


    fun getBase64(url: String): String {
        val urlConnection = URL(url).openConnection()
        val input = urlConnection.getInputStream()
        val value = input.readAllBytes()
        input.close()
        return Base64.getEncoder().encodeToString(value)
    }

    fun postBase64(url: String, parameterMap: Map<String, String>): String {
        val httpURLConnection = URL(url).openConnection() as HttpURLConnection
        httpURLConnection.doInput = true
        httpURLConnection.doOutput = true
        httpURLConnection.requestMethod = "POST"
        httpURLConnection.setRequestProperty("charset", "utf-8")
        val pw = PrintWriter(BufferedOutputStream(httpURLConnection.outputStream))
        val parameter = StringBuilder()
        for ((key, value) in parameterMap) parameter.append("&").append(URLEncoder.encode(key, StandardCharsets.UTF_8))
            .append("=").append(URLEncoder.encode(value, StandardCharsets.UTF_8))
        pw.write(parameter.toString())
        pw.flush()
        pw.close()
        val input = httpURLConnection.inputStream
        val value = input.readAllBytes()
        input.close()
        return Base64.getDecoder().decode(value).toString()
    }
}