package cn.wumoe.hime.module.http

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import cn.wumoe.hime.toWord

class HttpModule : Module("hime.http") {
    override fun init(context: HimeContext) {
        addFunction(Download())       // http-download
        addFunction(GetString())      // http-get-string
        addFunction(PostString())     // http-post-string
        addFunction(GetBase64())      // http-get-base64
        addFunction(PostBase64())     // http-post-base64
    }

    class Download : Function("http-download") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.size >= 2) {
                HttpUtil.download(pars[0].toString(), pars[1].toString())
                pars[1]
            } else
                Word.NIL
        }
    }

    class GetString : Function("http-get-string") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty())
                HttpUtil.get(pars[0].toString()).toWord()
            else
                Word.NIL
        }
    }

    class PostString : Function("http-post-string") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty()) {
                val map = HashMap<String, String>()
                for (i in 1 until pars.size) {
                    if (pars[i] is cn.wumoe.hime.lexer.Array
                        && (pars[i] as cn.wumoe.hime.lexer.Array).tokens.size >= 2
                    ) {
                        val array = (pars[i] as cn.wumoe.hime.lexer.Array).tokens
                        map[array[0].toString()] = array[1].toString()
                    } else
                        return Word.NIL
                }
                HttpUtil.post(pars[0].toString(), map).toWord()
            } else
                Word.NIL
        }
    }

    class GetBase64 : Function("http-get-base64") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty())
                HttpUtil.getBase64(pars[0].toString()).toWord()
            else
                Word.NIL
        }
    }

    class PostBase64 : Function("http-post-base64") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty()) {
                val map = HashMap<String, String>()
                for (i in 1 until pars.size) {
                    if (pars[i] is cn.wumoe.hime.lexer.Array
                        && (pars[i] as cn.wumoe.hime.lexer.Array).tokens.size >= 2
                    ) {
                        val array = (pars[i] as cn.wumoe.hime.lexer.Array).tokens
                        map[array[0].toString()] = array[1].toString()
                    } else
                        return Word.NIL
                }
                HttpUtil.postBase64(pars[0].toString(), map).toWord()
            } else
                Word.NIL
        }
    }
}