package cn.wumoe.hime.module

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.lexer.Num
import cn.wumoe.hime.lexer.Real
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import cn.wumoe.hime.simplification
import java.math.BigDecimal
import java.math.BigInteger

class ListModule : Module("hime.list") {
    override fun init(context: HimeContext) {
        addFunction(Reverse())      // reverse
        addFunction(Map())          // map
        addFunction(Filter())       // filter
        addFunction(Sort())         // sort
    }

    class Sort : Function("sort") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty() && pars[0] is cn.wumoe.hime.lexer.Array) {
                val result = cn.wumoe.hime.lexer.Array(ArrayList())
                val tokens = (pars[0] as cn.wumoe.hime.lexer.Array).tokens
                val array = arrayOfNulls<BigDecimal>(tokens.size)
                for (i in tokens.indices) {
                    if (tokens[i] is Num)
                        array[i] = BigDecimal((tokens[i] as Num).value)
                    else if (tokens[i] is Real)
                        array[i] = (tokens[i] as Real).value
                    else
                        return Word.NIL
                }
                mergeSort(array, 0, array.size - 1)
                for (i in array.indices) {
                    val s = array[i]?.simplification().toString()
                    if (s.contains("."))
                        tokens[i] = Real(array[i])
                    else
                        tokens[i] = Num(BigInteger(s))

                }
                for (i in tokens.size - 1 downTo 0)
                    result.tokens.add(tokens[i])
                result
            } else
                Word.NIL
        }

        private fun merge(a: Array<BigDecimal?>, low: Int, mid: Int, high: Int) {
            val temp = arrayOfNulls<BigDecimal>(high - low + 1)
            var i = low
            var j = mid + 1
            var k = 0
            while (i <= mid && j <= high)
                temp[k++] = if (a[i]!! > a[j]) a[i++] else a[j++]
            while (i <= mid)
                temp[k++] = a[i++]
            while (j <= high)
                temp[k++] = a[j++]
            for (k2 in temp.indices)
                a[k2 + low] = temp[k2]!!
        }

        private fun mergeSort(a: Array<BigDecimal?>, low: Int, high: Int) {
            val mid = (low + high) / 2
            if (low < high) {
                mergeSort(a, low, mid)
                mergeSort(a, mid + 1, high)
                merge(a, low, mid, high)
            }
        }
    }

    class Reverse : Function("reverse") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty() && pars[0] is cn.wumoe.hime.lexer.Array) {
                val result = cn.wumoe.hime.lexer.Array(ArrayList())
                val tokens = (pars[0] as cn.wumoe.hime.lexer.Array).tokens
                for (i in tokens.size - 1 downTo 0)
                    result.tokens.add(tokens[i])
                result
            } else
                Word.NIL
        }
    }

    class Map : Function("map") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.size >= 2 && pars[1] is cn.wumoe.hime.lexer.Array) {
                val result = cn.wumoe.hime.lexer.Array(ArrayList())
                val tokens = (pars[1] as cn.wumoe.hime.lexer.Array).tokens
                for (i in tokens.indices) {
                    val func = analysis.getFunction(pars[0].toString())
                    func.analysis = analysis
                    val array = arrayOfNulls<Token>(pars.size - 1)
                    array[0] = tokens[i]
                    for (j in 1 until  pars.size - 1)
                        array[j] = (pars[j + 1] as cn.wumoe.hime.lexer.Array).tokens[i]
                    result.add(func.call(array))
                }
                result
            } else
                Word.NIL
        }
    }

    class Filter : Function("filter") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.size >= 2 && pars[1] is cn.wumoe.hime.lexer.Array) {
                val result = cn.wumoe.hime.lexer.Array(ArrayList())
                val tokens = (pars[1] as cn.wumoe.hime.lexer.Array).tokens
                for (t in tokens) {
                    val func = analysis.getFunction(pars[0].toString())
                    func.analysis = analysis
                    if (func.call(arrayOf(t)) == Word.True)
                        result.add(t)
                }
                result
            } else
                Word.NIL
        }
    }
}