package cn.wumoe.hime.lexer;

import java.util.Objects;

public class Word extends Token {
    public final String lexeme;

    public Word(final String s, final Tag tag) {
        super(tag);
        this.lexeme = s;
    }

    public static final Word
        True = new Word("true", Tag.TRUE),
        False = new Word("false", Tag.FALSE),
        ELSE = new Word("else", Tag.ELSE),
        NIL = new Word("nil", Tag.NIL),
        LB = new Word("(", Tag.LB),
        RB = new Word(")", Tag.RB),
        STRUCTURE  = new Word("structure", Tag.STRUCTURE),
        SP = new Word(" ", Tag.SP);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Word word = (Word) o;
        return lexeme.equals(word.lexeme);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), lexeme);
    }

    @Override
    public String toString() {
        return lexeme;
    }
}
