package cn.wumoe.hime.lexer;

import java.util.Objects;

public class Token {
    public final Tag tag;
    public char c;

    public Token(final Tag tag) {
        this.tag = tag;
    }

    public Token(final char c) {
        this(Tag.DA);
        this.c = c;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;
        Token token = (Token) o;
        return c == token.c;
    }

    @Override
    public int hashCode() {
        return Objects.hash(c);
    }

    @Override
    public String toString() {
        return String.valueOf(this.c);
    }
}
