package cn.wumoe.hime.lexer;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public class Num extends Token {
    public final BigInteger value;

    public Num(BigInteger v) {
        super(Tag.NUM);
        this.value = v;
    }

    public static Num toNum(BigInteger i) {
        return new Num(i);
    }

    public static Num toNum(int i) {
        return toNum(BigInteger.valueOf(i));
    }

    public static Num toNum(long i) {
        return toNum(BigInteger.valueOf(i));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Num) {
            Num num = (Num) o;
            return value.compareTo(num.value) == 0;
        } else if (o instanceof Real) {
            Real real = (Real) o;
            return new BigDecimal(value.toString()).compareTo(real.value) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), value);
    }

    @Override
    public String toString() {
        return value.toString();
    }
}
