package cn.wumoe.hime.lexer;

import java.util.*;

public class Array extends Token {
    public final List<Token> tokens;

    public Array(Token[] tokens) {
        super(Tag.ARRAY);
        this.tokens = new ArrayList<>();
        Collections.addAll(this.tokens, tokens);
    }

    public Array(List<Token> tokens) {
        super(Tag.ARRAY);
        this.tokens = tokens;
    }

    public int size() {
        return tokens.size();
    }

    public void add(Token t) {
        tokens.add(t);
    }

    public void add(int i, Token t) {
        tokens.add(i, t);
    }

    public void set(int i, Token t) {
        tokens.set(i, t);
    }

    public Token get(int i) {
        return tokens.get(i);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Array array = (Array) o;
        return tokens.equals(array.tokens);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), tokens);
    }

    @Override
    public String toString() {
        return Arrays.toString(tokens.toArray());
    }
}
