package cn.wumoe.hime.gui;

import org.jetbrains.annotations.NotNull;

import javax.swing.*;
import java.io.OutputStream;

class JTextAreaOutputStream extends OutputStream {
    private final JTextArea destination;

    public JTextAreaOutputStream(JTextArea destination) {
        this.destination = destination;
    }

    @Override
    public void write(@NotNull byte[] buffer, int offset, int length) {
        final String text = new String(buffer, offset, length);
        SwingUtilities.invokeLater(() -> {
            destination.append(text);
            GUI.copy = destination.getText();
            GUI.length = destination.getText().length();
        });
    }

    @Override
    public void write(int b) {
        write(new byte[]{(byte) b}, 0, 1);
    }
}

