package cn.wumoe.hime.api.scripting

import cn.wumoe.hime.Config.VERSION
import java.lang.UnsupportedOperationException
import javax.script.ScriptEngineFactory

class HimeScriptEngineFactory : ScriptEngineFactory {
    override fun getLanguageVersion(): String = VERSION
    override fun getEngineVersion(): String = VERSION
    override fun getScriptEngine() = HimeScriptEngine()
    override fun getOutputStatement(toDisplay: String?): String = "(print $toDisplay)"
    override fun getExtensions(): List<String> = listOf("hime")
    override fun getMimeTypes(): List<String> = listOf("application/hime", "text/hime")
    override fun getLanguageName(): String = "Hime"
    override fun getNames() = arrayListOf("hime", "Hime", "HimeScript")
    override fun getProgram(vararg statements: String) = statements.joinToString { "($it)" }
    override fun getEngineName(): String = "Hime"

    override fun getParameter(key: String?): String? = when (key) {
        "javax.script.engine_version", "javax.script.language_version" -> VERSION
        "javax.script.engine", "javax.script.language", "javax.script.name" -> "hime"
        else -> null
    }

    override fun getMethodCallSyntax(obj: String, m: String, vararg args: String): String =
        throw UnsupportedOperationException("Can't invoke method!")
}