package cn.wumoe.hime.api.scripting

import cn.wumoe.hime.cast
import cn.wumoe.hime.semantic.SymbolList
import cn.wumoe.hime.inter.ASTNode
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.semantic.Analysis
import cn.wumoe.hime.toToken
import java.io.*
import java.util.concurrent.ConcurrentHashMap
import javax.script.Bindings
import javax.script.ScriptContext

class HimeContext(
    var bindings: SymbolList = SymbolList(
        ConcurrentHashMap(),
        ConcurrentHashMap(),
        ASTNode.EMPTY,
        Analysis.overallData,
        Analysis()
    ),
    private var reader: Reader = InputStreamReader(System.`in`),
    private var writer: Writer = OutputStreamWriter(System.out),
    private var errorWriter: Writer = OutputStreamWriter(System.err)
) : ScriptContext {
    constructor(data: SymbolList) : this() {
        this.bindings = data
    }

    override fun getReader(): Reader = reader
    override fun setReader(reader: Reader) {
        this.reader = reader
    }

    override fun getWriter(): Writer = writer
    override fun setWriter(writer: Writer) {
        this.writer = writer
    }

    private fun removeAttribute(name: String) = bindings.removeVariable(name)
    override fun removeAttribute(name: String, scope: Int) = removeAttribute(name)
    override fun getBindings(scope: Int): Bindings = bindings
    override fun setBindings(bindings: Bindings, scope: Int) {
        this.bindings = cast(bindings)
    }

    override fun getErrorWriter(): Writer = errorWriter
    override fun setErrorWriter(writer: Writer) {
        this.errorWriter = writer
    }

    override fun getAttribute(name: String) = bindings.getVariable(name) as Token
    private fun setAttribute(name: String, value: Any?) {
        bindings.addVariable(name, value!!.toToken())
    }

    override fun getAttribute(name: String, scope: Int) = getAttribute(name)
    override fun setAttribute(name: String, value: Any?, scope: Int) = setAttribute(name, value)
    override fun getScopes(): MutableList<Int> = throw UnsupportedOperationException()
    override fun getAttributesScope(name: String?): Int = throw UnsupportedOperationException()
}