package cn.wumoe.hime;

import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.function.RequireFun;
import cn.wumoe.hime.inter.ASTNode;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.*;
import cn.wumoe.hime.module.*;
import cn.wumoe.hime.module.http.HttpModule;
import cn.wumoe.hime.module.http.server.HttpServerModule;
import cn.wumoe.hime.module.properties.PropertiesModule;
import cn.wumoe.hime.module.socket.SocketModule;
import cn.wumoe.hime.module.thread.ThreadModule;
import cn.wumoe.hime.parser.Parser;
import cn.wumoe.hime.semantic.Analysis;
import cn.wumoe.hime.semantic.SymbolList;
import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.semantic.SymbolList;
import cn.wumoe.hime.function.RequireFun;
import cn.wumoe.hime.module.*;
import cn.wumoe.hime.module.http.HttpModule;
import cn.wumoe.hime.module.http.server.HttpServerModule;
import cn.wumoe.hime.module.properties.PropertiesModule;
import cn.wumoe.hime.module.socket.SocketModule;
import cn.wumoe.hime.module.thread.ThreadModule;
import cn.wumoe.hime.inter.ASTNode;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Lexer;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.parser.Parser;
import cn.wumoe.hime.semantic.Analysis;
import cn.wumoe.hime.function.RequireFun;
import cn.wumoe.hime.module.*;
import cn.wumoe.hime.module.http.HttpModule;
import cn.wumoe.hime.module.http.server.HttpServerModule;
import cn.wumoe.hime.module.properties.PropertiesModule;
import cn.wumoe.hime.module.socket.SocketModule;
import cn.wumoe.hime.module.thread.ThreadModule;
import cn.wumoe.hime.inter.ASTNode;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Lexer;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.parser.Parser;
import cn.wumoe.hime.semantic.Analysis;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;

public class Hime {
    private final Analysis analysis;

    public Hime() {
        analysis = new Analysis();
        analysis.addFunction(new RequireFun());
        analysis.addModule(new CoreModule(new HimeContext(analysis.head)));
        analysis.addModule(new MathModule());
        analysis.addModule(new StringModule());
        analysis.addModule(new ListModule());
        analysis.addModule(new TimeModule());
        analysis.addModule(new SystemModule());
        analysis.addModule(new HashModule());
        analysis.addModule(new SocketModule());
        analysis.addModule(new HttpModule());
        analysis.addModule(new Base64Module());
        analysis.addModule(new FileModule());
        analysis.addModule(new HttpServerModule());
        analysis.addModule(new QRCodeModule());
        analysis.addModule(new BarcodeModule());
        analysis.addModule(new PropertiesModule());
        analysis.addModule(new AESModule());
        analysis.addModule(new RSAModule());
        analysis.addModule(new ThreadModule());
        analysis.addModule(new TypeModule());
    }

    public Hime(SymbolList data, HimeContext context) {
        analysis = new Analysis(data);
        analysis.addFunction(new RequireFun());
        analysis.addModule(new CoreModule(context));
        analysis.addModule(new MathModule());
        analysis.addModule(new StringModule());
        analysis.addModule(new ListModule());
        analysis.addModule(new TimeModule());
        analysis.addModule(new SystemModule());
        analysis.addModule(new HashModule());
        analysis.addModule(new SocketModule());
        analysis.addModule(new HttpModule());
        analysis.addModule(new Base64Module());
        analysis.addModule(new FileModule());
        analysis.addModule(new HttpServerModule());
        analysis.addModule(new QRCodeModule());
        analysis.addModule(new BarcodeModule());
        analysis.addModule(new PropertiesModule());
        analysis.addModule(new AESModule());
        analysis.addModule(new RSAModule());
        analysis.addModule(new ThreadModule());
        analysis.addModule(new TypeModule());
    }

    public void addModule(Module module) {
        this.analysis.addModule(module);
    }

    public void addFunction(Function function) {
        this.analysis.addFunction(function);
    }

    public void addFunction(String name, LambdaFunctionV function) {
        this.analysis.addFunction(new LambdaFunction(name, function));
    }

    public void addFunction(String name, LambdaFunctionRV function) {
        this.analysis.addFunction(new LambdaFunctionR(name, function));
    }

    public interface LambdaFunctionRV {
        Token call(Token[] pars);
    }

    static class LambdaFunctionR extends Function {
        private final LambdaFunctionRV lambda;
        public LambdaFunctionR(String name, LambdaFunctionRV lambda) {
            super(name);
            this.lambda = lambda;
        }

        @Override
        public Token call(Token[] pars) {
            return lambda.call(pars);
        }
    }

    public interface LambdaFunctionV {
        void call(Token[] pars);
    }

    static class LambdaFunction extends Function {
        private final LambdaFunctionV lambda;
        public LambdaFunction(String name, LambdaFunctionV lambda) {
            super(name);
            this.lambda = lambda;
        }

        @Override
        public Token call(Token[] pars) {
            lambda.call(pars);
            return Word.NIL;
        }
    }

    public void addVariable(String key, Token value) {
        this.analysis.addVariable(key, value);
    }

    public void addVariable(String key, String value) {
        this.analysis.addVariable(key, new Word(value, Tag.STR));
    }

    public void addVariable(String key, int value) {
        this.analysis.addVariable(key, Num.toNum(value));
    }

    public void addVariable(String key, long value) {
        this.analysis.addVariable(key, Num.toNum(value));
    }

    public void addVariable(String key, float value) {
        this.analysis.addVariable(key, Real.toReal(value));
    }

    public void addVariable(String key, double value) {
        this.analysis.addVariable(key, Real.toReal(value));
    }

    public Token run(String value) {
        String s = Format.format(value);
        Lexer lex = new Lexer();
        lex.pushData(s);
        Parser parser = new Parser(lex);
        List<ASTNode> asts = parser.program();
        for (ASTNode node : asts)
            analysis.call(node);
        return asts.get(asts.size() - 1).tok;
    }

    public Token run(File file) throws IOException {
        String s = Format.format(Files.readString(file.toPath()));
        Lexer lex = new Lexer();
        lex.pushData(s);
        Parser parser = new Parser(lex);
        List<ASTNode> asts = parser.program();
        for (ASTNode node : asts)
            analysis.call(node);
        return asts.get(asts.size() - 1).tok;
    }
}
