/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.semantic;

import cn.wumoe.hime.exceptions.HimeParserException;
import cn.wumoe.hime.inter.ASTNode;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.semantic.SymbolList;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;

public class Analysis {
    public static final SymbolList overallData = new SymbolList(new ConcurrentHashMap<String, Module>(), new ConcurrentHashMap<String, Token>(), ASTNode.EMPTY, null, new Analysis());
    public final Deque<SymbolList> dataStack = new LinkedBlockingDeque<SymbolList>();
    public SymbolList head;
    public Analysis father;
    public boolean end;
    public boolean eval;
    public static Module module;
    public static Module require;

    public Analysis(SymbolList data) {
        this.head = data;
        this.dataStack.push(this.head);
        this.father = null;
        this.eval = false;
    }

    public Analysis() {
        this.head = new SymbolList(new ConcurrentHashMap<String, Module>(), new ConcurrentHashMap<String, Token>(), ASTNode.EMPTY, overallData, this);
        this.dataStack.push(this.head);
        this.father = null;
        this.eval = false;
    }

    public Analysis copy() {
        Analysis temp = new Analysis();
        temp.head.setFather(this.head);
        temp.father = this;
        return temp;
    }

    public boolean isEnd() {
        Analysis analysis = this;
        while (analysis != null && !analysis.end) {
            analysis = analysis.father;
        }
        return analysis != null;
    }

    public void endToFalse() {
        Analysis analysis = this;
        while (analysis != null && !analysis.end) {
            analysis = analysis.father;
        }
        if (analysis != null) {
            analysis.end = false;
        }
    }

    void error() throws HimeParserException {
        throw new HimeParserException("SymbolList Eq Null!");
    }

    public void addModule(Module module2) {
        this.head.addModule(module2);
    }

    public void addFunction(Function function) {
        this.head.addFunction(function);
    }

    public void addVariable(String key, Token value) {
        this.head.addVariable(key, value);
    }

    public void removeModule(Module module2) {
        this.head.removeModule(module2);
    }

    public void removeFunction(Function function) {
        this.head.removeFunction(function);
    }

    public void removeVariable(String key) {
        this.head.removeVariable(key);
    }

    public Token getVariable(String name) {
        return this.head.getVariable(name);
    }

    public Function getFunction(String name) {
        return this.head.getFunction(name);
    }

    public Module getModule(String name) {
        return this.head.getModule(name);
    }

    public boolean containsVariable(String name) {
        return this.head.containsVariable(name);
    }

    public boolean containsFunction(String name) {
        return this.head.containsFunction(name);
    }

    public boolean containsModule(String name) {
        return this.head.containsModule(name);
    }

    public void call(ASTNode node) throws HimeParserException {
        this.head.setAstNode(node);
        block0: while (true) {
            SymbolList data;
            if (this.dataStack.isEmpty()) {
                this.dataStack.push(this.head);
            }
            if ((data = this.dataStack.peek()) == null) {
                this.error();
                return;
            }
            ASTNode ast = data.getAstNode();
            Token tempToken = ast.tok;
            while (true) {
                assert (tempToken != null);
                if (!data.containsVariable(tempToken.toString()) || data.getVariable(tempToken.toString()) instanceof Function) break;
                tempToken = data.getVariable(tempToken.toString());
            }
            ast.tok = tempToken;
            if (ast.tok.tag == Tag.STRUCTURE && ast.size() >= 1) {
                Analysis temp = this.copy();
                temp.call(ast.get(0));
                ast.tok = ast.get((int)0).tok;
                ast.remove(ast.get(0));
            }
            if (data.containsFunction(ast.tok.toString()) && ast.tok.tag == Tag.ID) {
                Function func = data.getFunction(ast.tok.toString());
                assert (func != null);
                func.analysis = this;
                if (!func.keep) {
                    for (int i = 0; i < ast.size(); ++i) {
                        ASTNode next2 = ast.get(i);
                        assert (next2.tok != null);
                        tempToken = next2.tok;
                        while (true) {
                            assert (tempToken != null);
                            if (!data.containsVariable(tempToken.toString()) || data.getVariable(tempToken.toString()) instanceof Function || data.getVariable(tempToken.toString()) instanceof ASTNode) break;
                            tempToken = data.getVariable(tempToken.toString());
                        }
                        next2.tok = tempToken;
                        if (next2.tag == ASTNode.AstTag.FUNCTION) {
                            Function function = data.getFunction(next2.tok.toString());
                            assert (function != null);
                            function.analysis = this;
                            next2.tok = function.call(new Token[0]);
                            next2.tag = ASTNode.AstTag.BASIC;
                        }
                        if (next2.size() <= 0) continue;
                        this.dataStack.push(new SymbolList(new ConcurrentHashMap<String, Module>(), new ConcurrentHashMap<String, Token>(), next2, data, this));
                        continue block0;
                    }
                }
                Token[] tokens = new Token[func.keep ? 2 : ast.size()];
                if (func.keep) {
                    tokens[0] = ast;
                    tokens[1] = this.eval ? Objects.requireNonNull(data.getFather()).getFather() : data;
                } else {
                    for (int i = 0; i < ast.size(); ++i) {
                        tokens[i] = ast.get((int)i).tok;
                    }
                }
                ast.tok = func.call(tokens);
                ast.clear();
            }
            if ("module".equals(ast.tok.toString()) && module != null) {
                require = module;
                module = null;
            }
            this.dataStack.pop();
            if (this.dataStack.isEmpty()) break;
        }
    }
}

