/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module.socket;

import cn.wumoe.hime.KotlinExtendKt;
import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Num;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.module.socket.HimeSocketToken;
import java.io.Closeable;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\f\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0013"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule;", "Lcn/wumoe/hime/inter/Module;", "()V", "init", "", "himeContext", "Lcn/wumoe/hime/api/scripting/HimeContext;", "HimeServer", "HimeShutdownInput", "HimeShutdownOutput", "HimeSocket", "HimeSocketClose", "HimeSocketGetIp", "HimeSocketGetPort", "HimeSocketInputClose", "HimeSocketInputString", "HimeSocketPrintClose", "HimeSocketPrintFlush", "HimeSocketPrintString", "hime"})
public final class SocketModule
extends Module {
    public SocketModule() {
        super("hime.socket");
    }

    @Override
    public void init(@NotNull HimeContext himeContext) {
        Intrinsics.checkNotNullParameter((Object)himeContext, (String)"himeContext");
        this.addFunction(new HimeServer());
        this.addFunction(new HimeSocket());
        this.addFunction(new HimeSocketInputString());
        this.addFunction(new HimeSocketPrintString());
        this.addFunction(new HimeSocketInputClose());
        this.addFunction(new HimeSocketPrintClose());
        this.addFunction(new HimeSocketClose());
        this.addFunction(new HimeShutdownOutput());
        this.addFunction(new HimeShutdownInput());
        this.addFunction(new HimeSocketPrintFlush());
        this.addFunction(new HimeSocketGetIp());
        this.addFunction(new HimeSocketGetPort());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeSocketGetIp;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeSocketGetIp
    extends Function {
        public HimeSocketGetIp() {
            super("socket-get-ip");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeSocketToken) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.socket.HimeSocketToken");
                String string = ((HimeSocketToken)token2).getSocket().getLocalAddress().getHostAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[0] as HimeSocketTok\u2026.localAddress.hostAddress");
                token = KotlinExtendKt.toWord(string);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeSocketGetPort;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeSocketGetPort
    extends Function {
        public HimeSocketGetPort() {
            super("socket-get-port");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeSocketToken) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.socket.HimeSocketToken");
                token = KotlinExtendKt.toNum(((HimeSocketToken)token2).getSocket().getLocalPort());
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeSocketPrintFlush;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeSocketPrintFlush
    extends Function {
        public HimeSocketPrintFlush() {
            super("socket-writer-flush");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeSocketToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.socket.HimeSocketToken");
                ((HimeSocketToken)token).getPrintWriter().flush();
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeShutdownOutput;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeShutdownOutput
    extends Function {
        public HimeShutdownOutput() {
            super("socket-shutdown-writer");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeSocketToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.socket.HimeSocketToken");
                HimeSocketToken socketToken = (HimeSocketToken)token;
                socketToken.getSocket().shutdownOutput();
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeShutdownInput;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeShutdownInput
    extends Function {
        public HimeShutdownInput() {
            super("socket-shutdown-input");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeSocketToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.socket.HimeSocketToken");
                ((HimeSocketToken)token).getSocket().shutdownInput();
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeSocketPrintClose;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeSocketPrintClose
    extends Function {
        public HimeSocketPrintClose() {
            super("socket-writer-close");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeSocketToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.socket.HimeSocketToken");
                ((HimeSocketToken)token).getPrintWriter().close();
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeSocketInputClose;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeSocketInputClose
    extends Function {
        public HimeSocketInputClose() {
            super("socket-input-close");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeSocketToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.socket.HimeSocketToken");
                ((HimeSocketToken)token).getInputStream().close();
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeSocketClose;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeSocketClose
    extends Function {
        public HimeSocketClose() {
            super("socket-close");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeSocketToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.socket.HimeSocketToken");
                ((HimeSocketToken)token).getSocket().close();
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeSocketInputString;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeSocketInputString
    extends Function {
        public HimeSocketInputString() {
            super("socket-writer-string");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof HimeSocketToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.socket.HimeSocketToken");
                HimeSocketToken socketToken = (HimeSocketToken)token;
                InputStream inputStream = socketToken.getInputStream();
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
                byte[] byArray = bytes;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                return KotlinExtendKt.toWord(new String(byArray, charset2));
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeSocketPrintString;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeSocketPrintString
    extends Function {
        public HimeSocketPrintString() {
            super("socket-writer-string");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof HimeSocketToken) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.module.socket.HimeSocketToken");
                HimeSocketToken socketToken = (HimeSocketToken)token;
                socketToken.getPrintWriter().write(pars[1].toString());
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeServer;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeServer
    extends Function {
        public HimeServer() {
            super("socket-server");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof Num) {
                Token token = pars[0];
                Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                int port = ((Num)token).value.intValue();
                Closeable closeable = new ServerSocket(port);
                Throwable throwable = null;
                try {
                    ServerSocket serverSocket = (ServerSocket)closeable;
                    boolean bl = false;
                    while (!this.analysis.isEnd()) {
                        Socket socket = serverSocket.accept();
                        Intrinsics.checkNotNullExpressionValue((Object)socket, (String)"serverSocket.accept()");
                        HimeSocketToken socketToken = new HimeSocketToken(socket);
                        Function func = this.analysis.getFunction(pars[1].toString());
                        func.analysis = this.analysis;
                        Token[] tokenArray = new Token[]{socketToken};
                        func.call(tokenArray);
                    }
                    this.analysis.endToFalse();
                    serverSocket.close();
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    Token token2 = word;
                    return token2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/socket/SocketModule$HimeSocket;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class HimeSocket
    extends Function {
        public HimeSocket() {
            super("socket");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars[0] instanceof Word) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Word");
                String s = ((Word)token2).lexeme;
                Intrinsics.checkNotNullExpressionValue((Object)s, (String)"s");
                String string = s.substring(0, StringsKt.indexOf$default((CharSequence)s, (String)":", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String string2 = s.substring(StringsKt.indexOf$default((CharSequence)s, (String)":", (int)0, (boolean)false, (int)6, null) + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                token = new HimeSocketToken(new Socket(string, Integer.parseInt(string2)));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }
}

