/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module.http;

import cn.wumoe.hime.KotlinExtendKt;
import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Array;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.module.http.HttpUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005\u0007\b\t\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcn/wumoe/hime/module/http/HttpModule;", "Lcn/wumoe/hime/inter/Module;", "()V", "init", "", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "Download", "GetBase64", "GetString", "PostBase64", "PostString", "hime"})
public final class HttpModule
extends Module {
    public HttpModule() {
        super("hime.http");
    }

    @Override
    public void init(@NotNull HimeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.addFunction(new Download());
        this.addFunction(new GetString());
        this.addFunction(new PostString());
        this.addFunction(new GetBase64());
        this.addFunction(new PostBase64());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/HttpModule$Download;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Download
    extends Function {
        public Download() {
            super("http-download");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2) {
                String string = pars[0].toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[0].toString()");
                String string2 = pars[1].toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pars[1].toString()");
                HttpUtil.INSTANCE.download(string, string2);
                token = pars[1];
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/HttpModule$GetString;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class GetString
    extends Function {
        public GetString() {
            super("http-get-string");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                String string = pars[0].toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[0].toString()");
                token = KotlinExtendKt.toWord(HttpUtil.INSTANCE.get(string));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/HttpModule$PostString;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class PostString
    extends Function {
        public PostString() {
            super("http-post-string");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            block6: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
                    if (!(!(pars.length == 0))) break block3;
                    HashMap map = new HashMap();
                    int n = pars.length;
                    for (int i = 1; i < n; ++i) {
                        String string;
                        String string2;
                        block5: {
                            block4: {
                                if (!(pars[i] instanceof Array)) break block4;
                                Token token2 = pars[i];
                                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                                if (((Array)token2).tokens.size() >= 2) break block5;
                            }
                            Word word = Word.NIL;
                            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                            return word;
                        }
                        Token token3 = pars[i];
                        Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                        List<Token> array = ((Array)token3).tokens;
                        Map map2 = map;
                        Intrinsics.checkNotNullExpressionValue((Object)array.get(0).toString(), (String)"array[0].toString()");
                        Intrinsics.checkNotNullExpressionValue((Object)array.get(1).toString(), (String)"array[1].toString()");
                        map2.put(string2, string);
                    }
                    String string = pars[0].toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[0].toString()");
                    token = KotlinExtendKt.toWord(HttpUtil.INSTANCE.post(string, map));
                    break block6;
                }
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/HttpModule$GetBase64;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class GetBase64
    extends Function {
        public GetBase64() {
            super("http-get-base64");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                String string = pars[0].toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[0].toString()");
                token = KotlinExtendKt.toWord(HttpUtil.INSTANCE.getBase64(string));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/http/HttpModule$PostBase64;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class PostBase64
    extends Function {
        public PostBase64() {
            super("http-post-base64");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            block6: {
                block3: {
                    Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
                    if (!(!(pars.length == 0))) break block3;
                    HashMap map = new HashMap();
                    int n = pars.length;
                    for (int i = 1; i < n; ++i) {
                        String string;
                        String string2;
                        block5: {
                            block4: {
                                if (!(pars[i] instanceof Array)) break block4;
                                Token token2 = pars[i];
                                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                                if (((Array)token2).tokens.size() >= 2) break block5;
                            }
                            Word word = Word.NIL;
                            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                            return word;
                        }
                        Token token3 = pars[i];
                        Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                        List<Token> array = ((Array)token3).tokens;
                        Map map2 = map;
                        Intrinsics.checkNotNullExpressionValue((Object)array.get(0).toString(), (String)"array[0].toString()");
                        Intrinsics.checkNotNullExpressionValue((Object)array.get(1).toString(), (String)"array[1].toString()");
                        map2.put(string2, string);
                    }
                    String string = pars[0].toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[0].toString()");
                    token = KotlinExtendKt.toWord(HttpUtil.INSTANCE.postBase64(string, map));
                    break block6;
                }
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }
}

