/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.module;

import cn.wumoe.hime.Config;
import cn.wumoe.hime.KotlinExtendKt;
import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.exceptions.HimeRuntimeException;
import cn.wumoe.hime.function.CustomFun;
import cn.wumoe.hime.gui.GUI;
import cn.wumoe.hime.gui.HimeTokenMaker;
import cn.wumoe.hime.inter.ASTNode;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Array;
import cn.wumoe.hime.lexer.Lexer;
import cn.wumoe.hime.lexer.Num;
import cn.wumoe.hime.lexer.Real;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.parser.Parser;
import cn.wumoe.hime.semantic.Analysis;
import cn.wumoe.hime.semantic.SymbolList;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b.\u0018\u00002\u00020\u0001:-\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0016\u00a8\u00064"}, d2={"Lcn/wumoe/hime/module/CoreModule;", "Lcn/wumoe/hime/inter/Module;", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "(Lcn/wumoe/hime/api/scripting/HimeContext;)V", "init", "", "CoreAdd", "CoreAnd", "CoreAppend", "CoreBegin", "CoreCar", "CoreCdr", "CoreConcat", "CoreCond", "CoreCons", "CoreDef", "CoreDiv", "CoreEq", "CoreError", "CoreEval", "CoreGet", "CoreGreater", "CoreGreaterEq", "CoreIf", "CoreLambda", "CoreLen", "CoreLess", "CoreLessEq", "CoreList", "CoreModule", "CoreMult", "CoreNewLine", "CoreNot", "CoreNotEq", "CoreOr", "CoreRandom", "CoreRange", "CoreRead", "CoreReadBool", "CoreReadLine", "CoreReadNum", "CoreReadReal", "CoreReturn", "CoreSet", "CoreSub", "CoreSum", "CoreToNum", "CoreToReal", "CoreToString", "Print", "Println", "hime"})
public final class CoreModule
extends Module {
    public CoreModule(@NotNull HimeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super("hime.core", context);
    }

    @Override
    public void init(@NotNull HimeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.addFunction(new Println(context));
        this.addFunction(new Print(context));
        this.addFunction(new CoreSum());
        this.addFunction(new CoreSub());
        this.addFunction(new CoreDiv());
        this.addFunction(new CoreMult());
        this.addFunction(new CoreList());
        this.addFunction(new CoreAdd());
        this.addFunction(new CoreGet());
        this.addFunction(new CoreSet());
        this.addFunction(new CoreRange());
        this.addFunction(new CoreEq());
        this.addFunction(new CoreNotEq());
        this.addFunction(new CoreGreater());
        this.addFunction(new CoreLess());
        this.addFunction(new CoreGreaterEq());
        this.addFunction(new CoreLessEq());
        this.addFunction(new CoreAnd());
        this.addFunction(new CoreOr());
        this.addFunction(new CoreNot());
        this.addFunction(new CoreCons());
        this.addFunction(new CoreCar());
        this.addFunction(new CoreCdr());
        this.addFunction(new CoreAppend());
        this.addFunction(new CoreConcat());
        this.addFunction(new CoreLen());
        this.addFunction(new CoreReadLine(context));
        this.addFunction(new CoreRead(context));
        this.addFunction(new CoreReadNum(context));
        this.addFunction(new CoreReadReal(context));
        this.addFunction(new CoreReadBool(context));
        this.addFunction(new CoreToString());
        this.addFunction(new CoreToNum());
        this.addFunction(new CoreToReal());
        this.addFunction(new CoreLambda());
        this.addFunction(new CoreBegin());
        this.addFunction(new CoreIf());
        this.addFunction(new CoreCond());
        this.addFunction(new CoreDef());
        this.addFunction(new CoreModule());
        this.addFunction(new CoreNewLine());
        this.addFunction(new CoreRandom());
        this.addFunction(new CoreError());
        this.addFunction(new CoreReturn());
        this.addFunction(new CoreEval());
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreEval;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreEval
    extends Function {
        public CoreEval() {
            super("eval");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                Analysis temp = this.analysis.copy();
                temp.eval = true;
                String string = pars[0].toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[0].toString()");
                String value = string;
                Lexer lex = new Lexer();
                lex.pushData(value);
                Parser parser = new Parser(lex);
                List<ASTNode> asts = parser.program();
                for (ASTNode node : asts) {
                    temp.call(node);
                }
                Token token2 = asts.get((int)(asts.size() - 1)).tok;
                Intrinsics.checkNotNullExpressionValue((Object)token2, (String)"{\n                val te\u2026ze - 1].tok\n            }");
                token = token2;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreReturn;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreReturn
    extends Function {
        public CoreReturn() {
            super("return");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            this.analysis.end = true;
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreError;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreError
    extends Function {
        public CoreError() {
            super("error");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            throw new HimeRuntimeException(pars[0].toString());
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0002\u00a8\u0006\f"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreRandom;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "randomBigInteger", "Ljava/math/BigInteger;", "start", "end", "hime"})
    public static final class CoreRandom
    extends Function {
        public CoreRandom() {
            super("random");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof Num && pars[1] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                BigInteger bigInteger = ((Num)token2).value;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"pars[0] as Num).value");
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                BigInteger bigInteger2 = ((Num)token3).value;
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"pars[1] as Num).value");
                token = KotlinExtendKt.toNum(this.randomBigInteger(bigInteger, bigInteger2));
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }

        private final BigInteger randomBigInteger(BigInteger start, BigInteger end) {
            Random rand = new Random();
            int scale = end.toString().length();
            String generated = "";
            int n = end.toString().length();
            for (int i = 0; i < n; ++i) {
                generated = generated + rand.nextInt(10);
            }
            BigDecimal inputRangeStart = new BigDecimal("0").setScale(scale, RoundingMode.FLOOR);
            String string = "%0" + end.toString().length() + 'd';
            Object[] objectArray = new Object[]{0};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            BigDecimal inputRangeEnd = new BigDecimal(StringsKt.replace$default((String)string2, (char)'0', (char)'9', (boolean)false, (int)4, null)).setScale(scale, RoundingMode.FLOOR);
            BigDecimal outputRangeStart = new BigDecimal(start).setScale(scale, RoundingMode.FLOOR);
            BigDecimal outputRangeEnd = new BigDecimal(end).add(new BigDecimal("1")).setScale(scale, RoundingMode.FLOOR);
            BigDecimal bd1 = new BigDecimal(new BigInteger(generated)).setScale(scale, RoundingMode.FLOOR).subtract(inputRangeStart);
            BigDecimal bd2 = inputRangeEnd.subtract(inputRangeStart);
            BigDecimal bd3 = bd1.divide(bd2, RoundingMode.FLOOR);
            BigDecimal bd4 = outputRangeEnd.subtract(outputRangeStart);
            BigDecimal bd5 = bd3.multiply(bd4);
            BigDecimal bd6 = bd5.add(outputRangeStart);
            BigInteger returnInteger = bd6.setScale(0, RoundingMode.FLOOR).toBigInteger();
            BigInteger bigInteger = returnInteger = returnInteger.compareTo(end) > 0 ? end : returnInteger;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"returnInteger");
            return bigInteger;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreNewLine;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreNewLine
    extends Function {
        public CoreNewLine() {
            super("newline");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            System.out.println();
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreModule;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreModule
    extends Function {
        public CoreModule() {
            super("module", true);
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Module module2;
            Module module3;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            Token token = pars[0];
            Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.inter.ASTNode");
            ASTNode ast = (ASTNode)token;
            Analysis analysis = this.analysis.copy();
            Intrinsics.checkNotNullExpressionValue((Object)analysis, (String)"analysis.copy()");
            Analysis temp = analysis;
            Token token2 = pars[1];
            Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.semantic.SymbolList");
            SymbolList symbolList = (SymbolList)token2;
            String string = this.name;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            if (symbolList.containsModule(string)) {
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.semantic.SymbolList");
                SymbolList symbolList2 = (SymbolList)token3;
                String string2 = this.name;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name");
                module3 = symbolList2.getModule(string2);
            } else {
                String string3 = this.name;
                module3 = new Module(string3){

                    public void init(@NotNull HimeContext context) {
                        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    }
                };
            }
            Analysis.module = module2 = module3;
            for (ASTNode astNode : ast.prev) {
                temp.call(astNode);
            }
            Token token4 = ast.tok;
            Intrinsics.checkNotNullExpressionValue((Object)token4, (String)"ast.tok");
            return token4;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreDef;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreDef
    extends Function {
        public CoreDef() {
            super("def", true);
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            Token token = pars[0];
            Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.inter.ASTNode");
            ASTNode ast = (ASTNode)token;
            if (ast.size() >= 2) {
                Analysis analysis = this.analysis.copy();
                Intrinsics.checkNotNullExpressionValue((Object)analysis, (String)"analysis.copy()");
                Analysis temp = analysis;
                if (ast.get((int)0).tok instanceof Word) {
                    if (ast.get(0).size() >= 1 || ast.get((int)0).tag == ASTNode.AstTag.FUNCTION) {
                        String[] prs = new String[ast.get(0).size()];
                        int n = ast.get(0).size();
                        for (int i = 0; i < n; ++i) {
                            prs[i] = ast.get((int)0).get((int)i).tok.toString();
                        }
                        ASTNode[] asts = new ASTNode[ast.size() - 1];
                        int n2 = ast.size();
                        for (int i = 1; i < n2; ++i) {
                            asts[i - 1] = ast.get(i);
                        }
                        if (Analysis.module == null) {
                            Token token2 = pars[1];
                            Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.semantic.SymbolList");
                            SymbolList symbolList = (SymbolList)token2;
                            String string = ast.get((int)0).tok.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ast[0].tok.toString()");
                            symbolList.addFunction(new CustomFun(temp, string, asts, prs));
                        } else {
                            String string = ast.get((int)0).tok.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ast[0].tok.toString()");
                            Analysis.module.addFunction(new CustomFun(temp, string, asts, prs));
                        }
                    } else {
                        temp.call(ast.get(1));
                        if (Config.GUI) {
                            HimeTokenMaker.tokenMap.put(ast.get((int)0).tok.toString(), 17);
                        }
                        if (Analysis.module == null) {
                            Token token3 = pars[1];
                            Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.semantic.SymbolList");
                            SymbolList symbolList = (SymbolList)token3;
                            String string = ast.get((int)0).tok.toString();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ast[0].tok.toString()");
                            Token token4 = ast.get((int)1).tok;
                            Intrinsics.checkNotNullExpressionValue((Object)token4, (String)"ast[1].tok");
                            symbolList.addVariable(string, token4);
                        } else {
                            Analysis.module.addVariable(ast.get((int)0).tok.toString(), ast.get(1));
                        }
                    }
                }
            }
            ast.tok = Word.NIL;
            ast.clear();
            Token token5 = ast.tok;
            Intrinsics.checkNotNullExpressionValue((Object)token5, (String)"ast.tok");
            return token5;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreIf;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreIf
    extends Function {
        public CoreIf() {
            super("if", true);
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            Token token = pars[0];
            Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.inter.ASTNode");
            ASTNode ast = (ASTNode)token;
            if (ast.size() >= 1) {
                Analysis analysis = this.analysis.copy();
                Intrinsics.checkNotNullExpressionValue((Object)analysis, (String)"analysis.copy()");
                Analysis temp = analysis;
                temp.call(ast.get(0));
                if (Intrinsics.areEqual((Object)ast.get((int)0).tok, (Object)Word.True)) {
                    temp.call(ast.get(1));
                    ast.tok = ast.get((int)1).tok;
                    ast.clear();
                } else if (ast.size() < 3) {
                    ast.tok = Word.NIL;
                    ast.clear();
                } else {
                    temp.call(ast.get(2));
                    ast.tok = ast.get((int)2).tok;
                    ast.clear();
                }
            } else {
                ast.tok = Word.NIL;
                ast.clear();
            }
            Token token2 = ast.tok;
            Intrinsics.checkNotNullExpressionValue((Object)token2, (String)"ast.tok");
            return token2;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreCond;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreCond
    extends Function {
        public CoreCond() {
            super("cond", true);
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            Token token = pars[0];
            Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.inter.ASTNode");
            ASTNode ast = (ASTNode)token;
            Analysis temp = this.analysis.copy();
            boolean ok = false;
            for (ASTNode astNode : ast.prev) {
                if (astNode.tok == Word.ELSE) {
                    temp.call(astNode.get(0));
                    ast.tok = astNode.get((int)0).tok;
                    ast.clear();
                    ok = true;
                    continue;
                }
                temp.call(astNode.get(0));
                if (astNode.get((int)0).tok != Word.True && astNode.tok != Word.ELSE) continue;
                temp.call(astNode.get(1));
                ast.tok = astNode.get((int)1).tok;
                ast.clear();
                ok = true;
                break;
            }
            if (!ok) {
                ast.tok = Word.NIL;
                ast.clear();
            }
            Token token2 = ast.tok;
            Intrinsics.checkNotNullExpressionValue((Object)token2, (String)"ast.tok");
            return token2;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreBegin;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreBegin
    extends Function {
        public CoreBegin() {
            super("begin", true);
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            Token token = pars[0];
            Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.inter.ASTNode");
            ASTNode ast = (ASTNode)token;
            Analysis analysis = this.analysis.copy();
            Intrinsics.checkNotNullExpressionValue((Object)analysis, (String)"analysis.copy()");
            Analysis temp = analysis;
            for (ASTNode astNode : ast.prev) {
                temp.call(astNode);
            }
            ast.tok = ast.prev.get((int)(ast.prev.size() - 1)).tok;
            ast.clear();
            Token token2 = ast.tok;
            Intrinsics.checkNotNullExpressionValue((Object)token2, (String)"ast.tok");
            return token2;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreLambda;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "getRandomFunctionName", "", "hime"})
    public static final class CoreLambda
    extends Function {
        public CoreLambda() {
            super("lambda", true);
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            Token token = pars[0];
            Intrinsics.checkNotNull((Object)token, (String)"null cannot be cast to non-null type cn.wumoe.hime.inter.ASTNode");
            ASTNode ast = (ASTNode)token;
            Analysis analysis = this.analysis.copy();
            Intrinsics.checkNotNullExpressionValue((Object)analysis, (String)"analysis.copy()");
            Analysis temp = analysis;
            String name = this.getRandomFunctionName();
            if (ast.size() >= 2 && !Intrinsics.areEqual((Object)ast.get(0), (Object)ASTNode.EMPTY)) {
                String[] prs = new String[ast.get(0).size() + 1];
                prs[0] = ast.get((int)0).tok.toString();
                int n = ast.get(0).size();
                for (int i = 0; i < n; ++i) {
                    prs[i + 1] = ast.get((int)0).get((int)i).tok.toString();
                }
                ASTNode[] asts = new ASTNode[ast.size() - 1];
                int n2 = ast.size();
                for (int i = 1; i < n2; ++i) {
                    asts[i - 1] = ast.get(i);
                }
                Analysis.overallData.addFunction(new CustomFun(temp, name, asts, prs));
                ast.tok = new Word(name, Tag.ID);
                ast.clear();
            } else if (ast.size() >= 2) {
                ASTNode[] asts = new ASTNode[ast.size()];
                int n = ast.size();
                for (int i = 0; i < n; ++i) {
                    asts[i] = ast.get(i);
                }
                Analysis.overallData.addFunction(new CustomFun(temp, name, asts, new String[0]));
                ast.tok = new Word(name, Tag.ID);
                ast.clear();
            } else {
                ast.tok = Word.NIL;
                ast.clear();
            }
            Token token2 = ast.tok;
            Intrinsics.checkNotNullExpressionValue((Object)token2, (String)"ast.tok");
            return token2;
        }

        private final String getRandomFunctionName() {
            String str = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            StringBuilder builder = new StringBuilder();
            int size = ThreadLocalRandom.current().nextInt(6, 12);
            for (int i = 0; i < size; ++i) {
                int number = ThreadLocalRandom.current().nextInt(62);
                builder.append(str.charAt(number));
            }
            String string = builder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
            return string;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreToNum;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreToNum
    extends Function {
        public CoreToNum() {
            super("to-num");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            return KotlinExtendKt.toNum(new BigInteger(pars[0].toString()));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreToReal;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreToReal
    extends Function {
        public CoreToReal() {
            super("to-real");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            return KotlinExtendKt.toReal(new BigDecimal(pars[0].toString()));
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreToString;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreToString
    extends Function {
        public CoreToString() {
            super("to-string");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            return new Word(pars[0].toString(), Tag.STR);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreReadLine;", "Lcn/wumoe/hime/inter/Function;", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "(Lcn/wumoe/hime/api/scripting/HimeContext;)V", "getContext", "()Lcn/wumoe/hime/api/scripting/HimeContext;", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreReadLine
    extends Function {
        @NotNull
        private final HimeContext context;

        public CoreReadLine(@NotNull HimeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super("read-line");
            this.context = context;
        }

        @NotNull
        public final HimeContext getContext() {
            return this.context;
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (Config.GUI) {
                while (GUI.lineFlag.get() == GUI.flag.get()) {
                }
                GUI.flag.set(GUI.lineFlag.get());
            }
            String string = new Scanner(this.context.getReader()).nextLine();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Scanner(context.reader).nextLine()");
            return KotlinExtendKt.toWord(string);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreRead;", "Lcn/wumoe/hime/inter/Function;", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "(Lcn/wumoe/hime/api/scripting/HimeContext;)V", "getContext", "()Lcn/wumoe/hime/api/scripting/HimeContext;", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreRead
    extends Function {
        @NotNull
        private final HimeContext context;

        public CoreRead(@NotNull HimeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super("read");
            this.context = context;
        }

        @NotNull
        public final HimeContext getContext() {
            return this.context;
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (Config.GUI) {
                while (GUI.lineFlag.get() == GUI.flag.get()) {
                }
                GUI.flag.set(GUI.lineFlag.get());
            }
            String string = new Scanner(this.context.getReader()).next();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Scanner(context.reader).next()");
            return KotlinExtendKt.toWord(string);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreReadNum;", "Lcn/wumoe/hime/inter/Function;", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "(Lcn/wumoe/hime/api/scripting/HimeContext;)V", "getContext", "()Lcn/wumoe/hime/api/scripting/HimeContext;", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreReadNum
    extends Function {
        @NotNull
        private final HimeContext context;

        public CoreReadNum(@NotNull HimeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super("read-num");
            this.context = context;
        }

        @NotNull
        public final HimeContext getContext() {
            return this.context;
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (Config.GUI) {
                while (GUI.lineFlag.get() == GUI.flag.get()) {
                }
                GUI.flag.set(GUI.lineFlag.get());
            }
            BigInteger bigInteger = new Scanner(this.context.getReader()).nextBigInteger();
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"Scanner(context.reader).nextBigInteger()");
            return KotlinExtendKt.toNum(bigInteger);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreReadReal;", "Lcn/wumoe/hime/inter/Function;", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "(Lcn/wumoe/hime/api/scripting/HimeContext;)V", "getContext", "()Lcn/wumoe/hime/api/scripting/HimeContext;", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreReadReal
    extends Function {
        @NotNull
        private final HimeContext context;

        public CoreReadReal(@NotNull HimeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super("read-real");
            this.context = context;
        }

        @NotNull
        public final HimeContext getContext() {
            return this.context;
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (Config.GUI) {
                while (GUI.lineFlag.get() == GUI.flag.get()) {
                }
                GUI.flag.set(GUI.lineFlag.get());
            }
            BigDecimal bigDecimal = new Scanner(this.context.getReader()).nextBigDecimal();
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"Scanner(context.reader).nextBigDecimal()");
            return KotlinExtendKt.toReal(bigDecimal);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreReadBool;", "Lcn/wumoe/hime/inter/Function;", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "(Lcn/wumoe/hime/api/scripting/HimeContext;)V", "getContext", "()Lcn/wumoe/hime/api/scripting/HimeContext;", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreReadBool
    extends Function {
        @NotNull
        private final HimeContext context;

        public CoreReadBool(@NotNull HimeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super("read-bool");
            this.context = context;
        }

        @NotNull
        public final HimeContext getContext() {
            return this.context;
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (Config.GUI) {
                while (GUI.lineFlag.get() == GUI.flag.get()) {
                }
                GUI.flag.set(GUI.lineFlag.get());
            }
            boolean bool = new Scanner(this.context.getReader()).nextBoolean();
            return KotlinExtendKt.toBool(bool);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreLen;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreLen
    extends Function {
        public CoreLen() {
            super("len");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars[0] instanceof Array) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                token = KotlinExtendKt.toNum(((Array)token2).tokens.size());
            } else if (pars[0] instanceof Word) {
                token = KotlinExtendKt.toNum(pars[0].toString().length());
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreConcat;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreConcat
    extends Function {
        public CoreConcat() {
            super("concat");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            StringBuilder builder = new StringBuilder();
            for (Token t : pars) {
                builder.append(t.toString());
            }
            return new Word(builder.toString(), Tag.STR);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreGreater;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreGreater
    extends Function {
        public CoreGreater() {
            super(">");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2) {
                Token token;
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2;
                if (pars[0] instanceof Num) {
                    Token token2 = pars[0];
                    Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    bigDecimal2 = new BigDecimal(((Num)token2).value.toString());
                } else if (pars[0] instanceof Real) {
                    Token token3 = pars[0];
                    Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    bigDecimal2 = ((Real)token3).value;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                BigDecimal parOne = bigDecimal2;
                if (pars[1] instanceof Num) {
                    Token token4 = pars[1];
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    bigDecimal = new BigDecimal(((Num)token4).value.toString());
                } else if (pars[1] instanceof Real) {
                    Token token5 = pars[1];
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    bigDecimal = ((Real)token5).value;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                BigDecimal parTwo = bigDecimal;
                if (parOne != null) {
                    Word word = parOne.compareTo(parTwo) > 0 ? Word.True : Word.False;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"{\n                    if\u2026d.False\n                }");
                    token = word;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    token = word;
                }
                return token;
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreLess;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreLess
    extends Function {
        public CoreLess() {
            super("<");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2) {
                Token token;
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2;
                if (pars[0] instanceof Num) {
                    Token token2 = pars[0];
                    Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    bigDecimal2 = new BigDecimal(((Num)token2).value.toString());
                } else if (pars[0] instanceof Real) {
                    Token token3 = pars[0];
                    Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    bigDecimal2 = ((Real)token3).value;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                BigDecimal parOne = bigDecimal2;
                if (pars[1] instanceof Num) {
                    Token token4 = pars[1];
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    bigDecimal = new BigDecimal(((Num)token4).value.toString());
                } else if (pars[1] instanceof Real) {
                    Token token5 = pars[1];
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    bigDecimal = ((Real)token5).value;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                BigDecimal parTwo = bigDecimal;
                if (parOne != null) {
                    Word word = parOne.compareTo(parTwo) < 0 ? Word.True : Word.False;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"{\n                    if\u2026d.False\n                }");
                    token = word;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    token = word;
                }
                return token;
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreGreaterEq;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreGreaterEq
    extends Function {
        public CoreGreaterEq() {
            super(">=");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2) {
                Token token;
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2;
                if (pars[0] instanceof Num) {
                    Token token2 = pars[0];
                    Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    bigDecimal2 = new BigDecimal(((Num)token2).value.toString());
                } else if (pars[0] instanceof Real) {
                    Token token3 = pars[0];
                    Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    bigDecimal2 = ((Real)token3).value;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                BigDecimal parOne = bigDecimal2;
                if (pars[1] instanceof Num) {
                    Token token4 = pars[1];
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    bigDecimal = new BigDecimal(((Num)token4).value.toString());
                } else if (pars[1] instanceof Real) {
                    Token token5 = pars[1];
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    bigDecimal = ((Real)token5).value;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                BigDecimal parTwo = bigDecimal;
                if (parOne != null) {
                    Word word = parOne.compareTo(parTwo) >= 0 ? Word.True : Word.False;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"{\n                    if\u2026d.False\n                }");
                    token = word;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    token = word;
                }
                return token;
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreLessEq;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreLessEq
    extends Function {
        public CoreLessEq() {
            super("<=");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2) {
                Token token;
                BigDecimal bigDecimal;
                BigDecimal bigDecimal2;
                if (pars[0] instanceof Num) {
                    Token token2 = pars[0];
                    Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    bigDecimal2 = new BigDecimal(((Num)token2).value.toString());
                } else if (pars[0] instanceof Real) {
                    Token token3 = pars[0];
                    Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    bigDecimal2 = ((Real)token3).value;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                BigDecimal parOne = bigDecimal2;
                if (pars[1] instanceof Num) {
                    Token token4 = pars[1];
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    bigDecimal = new BigDecimal(((Num)token4).value.toString());
                } else if (pars[1] instanceof Real) {
                    Token token5 = pars[1];
                    Intrinsics.checkNotNull((Object)token5, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Real");
                    bigDecimal = ((Real)token5).value;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                BigDecimal parTwo = bigDecimal;
                if (parOne != null) {
                    Word word = parOne.compareTo(parTwo) <= 0 ? Word.True : Word.False;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"{\n                    if\u2026d.False\n                }");
                    token = word;
                } else {
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    token = word;
                }
                return token;
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreEq;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreEq
    extends Function {
        public CoreEq() {
            super("=");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            int n = pars.length;
            for (int i = 1; i < n; ++i) {
                if (Intrinsics.areEqual((Object)pars[i], (Object)pars[i - 1])) continue;
                Word word = Word.False;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"False");
                return word;
            }
            Word word = Word.True;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"True");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreNotEq;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreNotEq
    extends Function {
        public CoreNotEq() {
            super("!=");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            int n = pars.length;
            for (int i = 1; i < n; ++i) {
                if (Intrinsics.areEqual((Object)pars[i], (Object)pars[i - 1])) continue;
                Word word = Word.True;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"True");
                return word;
            }
            Word word = Word.False;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"False");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreNot;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreNot
    extends Function {
        public CoreNot() {
            super("not");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0) && pars[0] instanceof Word) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Word");
                Word word = ((Word)token2).tag == Tag.TRUE ? Word.False : Word.True;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"if ((pars[0] as Word).ta\u2026                Word.True");
                token = word;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreAnd;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreAnd
    extends Function {
        public CoreAnd() {
            super("and");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                for (Token t : pars) {
                    if (t instanceof Word) {
                        if (t.tag != Tag.FALSE) continue;
                        Word word = Word.False;
                        Intrinsics.checkNotNullExpressionValue((Object)word, (String)"False");
                        return word;
                    }
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                Word word = Word.True;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"True");
                return word;
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreOr;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreOr
    extends Function {
        public CoreOr() {
            super("or");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                for (Token t : pars) {
                    if (t instanceof Word) {
                        if (t.tag != Tag.TRUE) continue;
                        Word word = Word.True;
                        Intrinsics.checkNotNullExpressionValue((Object)word, (String)"True");
                        return word;
                    }
                    Word word = Word.NIL;
                    Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                    return word;
                }
                Word word = Word.False;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"False");
                return word;
            }
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreList;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreList
    extends Function {
        public CoreList() {
            super("list");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            return new Array(pars);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreAppend;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreAppend
    extends Function {
        public CoreAppend() {
            super("append");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            ArrayList<Token> temp = new ArrayList<Token>();
            for (Token t : pars) {
                if (t instanceof Array) {
                    temp.addAll((Collection)((Array)t).tokens);
                    continue;
                }
                temp.add(t);
            }
            return new Array((List<Token>)temp);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreCons;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreCons
    extends Function {
        public CoreCons() {
            super("cons");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            Token[] tokenArray = new Token[]{pars[0], pars[1]};
            return new Array(tokenArray);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreCar;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreCar
    extends Function {
        public CoreCar() {
            super("car");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars[0] instanceof Array) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Token token3 = ((Array)token2).get(0);
                token = token3;
                Intrinsics.checkNotNullExpressionValue((Object)token3, (String)"(pars[0] as cn.wumoe.hime.lexer.Array)[0]");
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreCdr;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreCdr
    extends Function {
        public CoreCdr() {
            super("cdr");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars[0] instanceof Array) {
                ArrayList array = new ArrayList();
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                array.addAll(((Array)token2).tokens);
                Token token3 = pars[0];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                array.remove(((Array)token3).tokens.get(0));
                Token token4 = array.size() == 1 ? (Token)array.get(0) : (Token)new Array(array);
                Intrinsics.checkNotNullExpressionValue((Object)token4, (String)"{\n                val ar\u2026rray(array)\n            }");
                token = token4;
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreGet;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreGet
    extends Function {
        public CoreGet() {
            super("get");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof Array && pars[1] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array array = (Array)token2;
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                Token token4 = array.get(((Num)token3).value.intValue());
                token = token4;
                Intrinsics.checkNotNullExpressionValue((Object)token4, (String)"pars[0] as cn.wumoe.hime\u20261] as Num).value.toInt())");
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreSet;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreSet
    extends Function {
        public CoreSet() {
            super("set");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 3 && pars[0] instanceof Array && pars[1] instanceof Num) {
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                Array array = (Array)token2;
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                array.set(((Num)token3).value.intValue(), pars[2]);
                token = pars[0];
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreAdd;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreAdd
    extends Function {
        public CoreAdd() {
            super("add");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof Array) {
                if (pars.length >= 3) {
                    Token token2 = pars[0];
                    Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                    Array array = (Array)token2;
                    Token token3 = pars[1];
                    Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    array.add(((Num)token3).value.intValue(), pars[2]);
                    token = pars[2];
                } else {
                    Token token4 = pars[0];
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Array");
                    ((Array)token4).add(pars[1]);
                    token = pars[1];
                }
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreRange;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreRange
    extends Function {
        public CoreRange() {
            super("range");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (pars.length >= 2 && pars[0] instanceof Num && pars[1] instanceof Num) {
                BigInteger bigInteger;
                Token token2 = pars[0];
                Intrinsics.checkNotNull((Object)token2, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                BigInteger start = ((Num)token2).value;
                Token token3 = pars[1];
                Intrinsics.checkNotNull((Object)token3, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                BigInteger end = ((Num)token3).value;
                if (pars.length >= 3) {
                    Token token4 = pars[2];
                    Intrinsics.checkNotNull((Object)token4, (String)"null cannot be cast to non-null type cn.wumoe.hime.lexer.Num");
                    bigInteger = ((Num)token4).value;
                } else {
                    bigInteger = BigInteger.ONE;
                }
                BigInteger step = bigInteger;
                BigInteger size = end.subtract(start).divide(step);
                ArrayList<Num> array = new ArrayList<Num>();
                BigInteger i = BigInteger.ZERO;
                while (i.compareTo(size) != 1) {
                    BigInteger bigInteger2 = start.add(i.multiply(step));
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"start.add(i.multiply(step))");
                    array.add(KotlinExtendKt.toNum(bigInteger2));
                    i = i.add(BigInteger.ONE);
                }
                token = new Array((List<Token>)array);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreSum;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreSum
    extends Function {
        public CoreSum() {
            super("+");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                BigDecimal num = BigDecimal.ZERO;
                for (Token t : pars) {
                    num = num.add(new BigDecimal(t.toString()));
                }
                BigDecimal bigDecimal = num;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"num");
                String string = KotlinExtendKt.simplification(bigDecimal).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"num.simplification().toString()");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)".", (boolean)false, (int)2, null)) {
                    BigDecimal bigDecimal2 = num;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"num");
                    token = KotlinExtendKt.toNum(new BigInteger(KotlinExtendKt.simplification(bigDecimal2).toString()));
                } else {
                    BigDecimal bigDecimal3 = num;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"num");
                    token = KotlinExtendKt.toReal(bigDecimal3);
                }
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreSub;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreSub
    extends Function {
        public CoreSub() {
            super("-");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                BigDecimal num = new BigDecimal(pars[0].toString());
                int n = pars.length;
                for (int i = 1; i < n; ++i) {
                    Intrinsics.checkNotNullExpressionValue((Object)num.subtract(new BigDecimal(pars[i].toString())), (String)"num.subtract(BigDecimal(pars[i].toString()))");
                }
                String string = KotlinExtendKt.simplification(num).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"num.simplification().toString()");
                token = !StringsKt.contains$default((CharSequence)string, (CharSequence)".", (boolean)false, (int)2, null) ? (Token)KotlinExtendKt.toNum(new BigInteger(KotlinExtendKt.simplification(num).toString())) : (Token)KotlinExtendKt.toReal(num);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreDiv;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreDiv
    extends Function {
        public CoreDiv() {
            super("/");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                BigDecimal num = new BigDecimal(pars[0].toString());
                int n = pars.length;
                for (int i = 1; i < n; ++i) {
                    Intrinsics.checkNotNullExpressionValue((Object)num.divide(new BigDecimal(pars[i].toString()), 10, RoundingMode.CEILING), (String)"num.divide(BigDecimal(pa\u202610, RoundingMode.CEILING)");
                }
                String string = KotlinExtendKt.simplification(num).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"num.simplification().toString()");
                token = !StringsKt.contains$default((CharSequence)string, (CharSequence)".", (boolean)false, (int)2, null) ? (Token)KotlinExtendKt.toNum(new BigInteger(KotlinExtendKt.simplification(num).toString())) : (Token)KotlinExtendKt.toReal(num);
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/module/CoreModule$CoreMult;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class CoreMult
    extends Function {
        public CoreMult() {
            super("*");
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Token token;
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            if (!(pars.length == 0)) {
                BigDecimal num = BigDecimal.ONE;
                for (Token t : pars) {
                    num = num.multiply(new BigDecimal(t.toString()));
                }
                BigDecimal bigDecimal = num;
                Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"num");
                String string = KotlinExtendKt.simplification(bigDecimal).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"num.simplification().toString()");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)".", (boolean)false, (int)2, null)) {
                    BigDecimal bigDecimal2 = num;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"num");
                    token = KotlinExtendKt.toNum(new BigInteger(KotlinExtendKt.simplification(bigDecimal2).toString()));
                } else {
                    BigDecimal bigDecimal3 = num;
                    Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"num");
                    token = KotlinExtendKt.toReal(bigDecimal3);
                }
            } else {
                Word word = Word.NIL;
                Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
                token = word;
            }
            return token;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcn/wumoe/hime/module/CoreModule$Println;", "Lcn/wumoe/hime/inter/Function;", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "(Lcn/wumoe/hime/api/scripting/HimeContext;)V", "getContext", "()Lcn/wumoe/hime/api/scripting/HimeContext;", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Println
    extends Function {
        @NotNull
        private final HimeContext context;

        public Println(@NotNull HimeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super("println");
            this.context = context;
        }

        @NotNull
        public final HimeContext getContext() {
            return this.context;
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            StringBuilder builder = new StringBuilder();
            for (Token token : pars) {
                builder.append(token.toString());
            }
            this.context.getWriter().write(builder.toString() + '\n');
            this.context.getWriter().flush();
            Config.OUT = true;
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001d\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcn/wumoe/hime/module/CoreModule$Print;", "Lcn/wumoe/hime/inter/Function;", "context", "Lcn/wumoe/hime/api/scripting/HimeContext;", "(Lcn/wumoe/hime/api/scripting/HimeContext;)V", "getContext", "()Lcn/wumoe/hime/api/scripting/HimeContext;", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
    public static final class Print
    extends Function {
        @NotNull
        private final HimeContext context;

        public Print(@NotNull HimeContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super("print");
            this.context = context;
        }

        @NotNull
        public final HimeContext getContext() {
            return this.context;
        }

        @Override
        @NotNull
        public Token call(@NotNull Token[] pars) {
            Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
            StringBuilder builder = new StringBuilder();
            for (Token token : pars) {
                builder.append(token.toString());
            }
            this.context.getWriter().write(builder.toString());
            this.context.getWriter().flush();
            Config.OUT = true;
            Word word = Word.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
            return word;
        }
    }
}

