/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.lexer;

import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import java.util.Objects;

public class Word
extends Token {
    public final String lexeme;
    public static final Word True = new Word("true", Tag.TRUE);
    public static final Word False = new Word("false", Tag.FALSE);
    public static final Word ELSE = new Word("else", Tag.ELSE);
    public static final Word NIL = new Word("nil", Tag.NIL);
    public static final Word LB = new Word("(", Tag.LB);
    public static final Word RB = new Word(")", Tag.RB);
    public static final Word STRUCTURE = new Word("structure", Tag.STRUCTURE);
    public static final Word SP = new Word(" ", Tag.SP);

    public Word(String s, Tag tag) {
        super(tag);
        this.lexeme = s;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Word word = (Word)o;
        return this.lexeme.equals(word.lexeme);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.lexeme);
    }

    @Override
    public String toString() {
        return this.lexeme;
    }
}

