/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.lexer;

import cn.wumoe.hime.lexer.Num;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public class Real
extends Token {
    public final BigDecimal value;

    public Real(BigDecimal v) {
        super(Tag.REAL);
        this.value = v;
    }

    public static Real toReal(BigDecimal f) {
        return new Real(f);
    }

    public static Real toReal(double f) {
        return new Real(BigDecimal.valueOf(f));
    }

    public static Real toReal(float f) {
        return new Real(BigDecimal.valueOf(f));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Real) {
            Real real = (Real)o;
            return this.value.compareTo(real.value) == 0;
        }
        if (o instanceof Num) {
            Num num = (Num)o;
            return new BigInteger(num.toString()).compareTo(num.value) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public String toString() {
        if (BigDecimal.ZERO.equals(this.value)) {
            return this.value.toString();
        }
        String s = this.value.toString();
        for (int i = s.length() - 1; i >= 0 && (s.charAt(i) == '0' || s.charAt(i) == '.'); --i) {
            s = s.substring(0, i);
        }
        return s;
    }
}

