/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.lexer;

import cn.wumoe.hime.lexer.Real;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;

public class Num
extends Token {
    public final BigInteger value;

    public Num(BigInteger v) {
        super(Tag.NUM);
        this.value = v;
    }

    public static Num toNum(BigInteger i) {
        return new Num(i);
    }

    public static Num toNum(int i) {
        return Num.toNum(BigInteger.valueOf(i));
    }

    public static Num toNum(long i) {
        return Num.toNum(BigInteger.valueOf(i));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Num) {
            Num num = (Num)o;
            return this.value.compareTo(num.value) == 0;
        }
        if (o instanceof Real) {
            Real real = (Real)o;
            return new BigDecimal(this.value.toString()).compareTo(real.value) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public String toString() {
        return this.value.toString();
    }
}

