/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.lexer;

import cn.wumoe.hime.lexer.Num;
import cn.wumoe.hime.lexer.Real;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Lexer {
    public int line = 0;
    char peek = (char)32;
    final Map<String, Word> words = new HashMap<String, Word>();
    int index = 0;
    final List<char[]> data = new LinkedList<char[]>();
    boolean keep = false;
    public boolean state;

    void reserve(Word w) {
        this.words.put(w.lexeme, w);
    }

    public Lexer() {
        this.reserve(Word.True);
        this.reserve(Word.False);
        this.reserve(Word.ELSE);
        this.reserve(Word.NIL);
    }

    void read() {
        char[] chars = this.data.get(this.line);
        if (this.index >= chars.length) {
            ++this.line;
            this.index = 0;
        }
        this.peek = chars[this.index++];
        if (this.line >= this.data.size()) {
            this.state = false;
        }
    }

    public void pushData(String data) {
        this.state = true;
        StringBuilder builder = new StringBuilder();
        for (char c : data.toCharArray()) {
            if (!this.keep && c == '\n') {
                this.data.add(builder.toString().toCharArray());
                builder = new StringBuilder();
                continue;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            this.data.add(builder.toString().toCharArray());
        }
    }

    public Token scan() {
        this.read();
        switch (this.peek) {
            case '(': {
                return Word.LB;
            }
            case ')': {
                return Word.RB;
            }
            case ' ': {
                return Word.SP;
            }
        }
        boolean negative = false;
        if (this.peek == '-' && this.index < this.data.get(this.line).length - 1 && Character.isDigit(this.data.get(this.line)[this.index])) {
            negative = true;
            this.read();
        }
        if (Character.isDigit(this.peek)) {
            BigInteger v = BigInteger.ZERO;
            while (true) {
                if (!this.state || !Character.isDigit(this.peek)) {
                    --this.index;
                    break;
                }
                v = v.multiply(BigInteger.valueOf(10L)).add(BigInteger.valueOf(Character.digit(this.peek, 10)));
                this.read();
            }
            if (this.peek != '.') {
                return negative ? new Num(v.subtract(v.multiply(BigInteger.TWO))) : new Num(v);
            }
            BigDecimal x = new BigDecimal(v.toString());
            BigDecimal d = BigDecimal.valueOf(10L);
            this.read();
            while (true) {
                this.read();
                if (!this.state || !Character.isDigit(this.peek)) {
                    --this.index;
                    break;
                }
                x = x.add(BigDecimal.valueOf(Character.digit(this.peek, 10)).divide(d, 10, RoundingMode.CEILING));
                d = d.multiply(BigDecimal.valueOf(10L));
            }
            return negative ? new Real(x.subtract(x.multiply(BigDecimal.valueOf(2L)))) : new Real(x);
        }
        if (this.peek == '\"') {
            this.keep = true;
            StringBuilder builder = new StringBuilder();
            boolean skip = false;
            while (true) {
                this.read();
                if (this.index + 1 < this.data.get(this.line).length && (this.data.get(this.line)[this.index + 1] == '\\' || this.data.get(this.line)[this.index + 1] == '\"') && this.peek == '\\') {
                    if (skip) {
                        skip = false;
                        builder.append("\\");
                        continue;
                    }
                    if (this.index + 1 < this.data.get(this.line).length && this.data.get(this.line)[this.index + 1] != 'n') {
                        builder.append("\\");
                        continue;
                    }
                    skip = true;
                    continue;
                }
                if (!this.state || this.peek == '\"') {
                    if (!skip) break;
                    skip = false;
                    builder.append("\"");
                    continue;
                }
                builder.append(this.peek);
            }
            this.keep = false;
            return new Word(builder.toString(), Tag.STR);
        }
        if (this.peek != ' ' && this.peek != '(' && this.peek != ')') {
            StringBuilder builder = new StringBuilder();
            while (true) {
                if (!this.state || this.peek == ' ' || this.peek == ')') {
                    --this.index;
                    break;
                }
                builder.append(this.peek);
                this.read();
            }
            String s = builder.toString();
            if (this.words.containsKey(s)) {
                return this.words.get(s);
            }
            return new Word(builder.toString(), Tag.ID);
        }
        return new Token(this.peek);
    }
}

