/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime.function;

import cn.wumoe.hime.Format;
import cn.wumoe.hime.exceptions.HimeModuleException;
import cn.wumoe.hime.inter.ASTNode;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Lexer;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.parser.Parser;
import cn.wumoe.hime.semantic.Analysis;
import java.io.File;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcn/wumoe/hime/function/RequireFun;", "Lcn/wumoe/hime/inter/Function;", "()V", "call", "Lcn/wumoe/hime/lexer/Token;", "pars", "", "([Lcn/wumoe/hime/lexer/Token;)Lcn/wumoe/hime/lexer/Token;", "hime"})
public final class RequireFun
extends Function {
    public RequireFun() {
        super("require");
    }

    @Override
    @NotNull
    public Token call(@NotNull Token[] pars) {
        Intrinsics.checkNotNullParameter((Object)pars, (String)"pars");
        if (!(pars.length == 0)) {
            File file;
            String string = pars[0].toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pars[0].toString()");
            String path = string;
            if (this.analysis.containsModule(path)) {
                Module module2 = this.analysis.getModule(path);
                if (module2 != null) {
                    for (Function function : module2.functions) {
                        this.analysis.addFunction(function);
                    }
                    Map<String, Token> map = module2.variableMap;
                    Intrinsics.checkNotNullExpressionValue(map, (String)"module.variableMap");
                    for (Map.Entry entry : map.entrySet()) {
                        this.analysis.addVariable((String)entry.getKey(), (Token)entry.getValue());
                    }
                } else {
                    throw new HimeModuleException("Module " + path + " does not exist!!!");
                }
            }
            if ((file = new File("./" + StringsKt.replace$default((String)path, (String)".", (String)"/", (boolean)false, (int)4, null) + ".hime")).exists()) {
                Lexer lex = new Lexer();
                lex.pushData(Format.format(Files.readString(file.toPath())));
                Parser parser = new Parser(lex);
                List<ASTNode> asts = parser.program();
                Analysis temp = new Analysis(this.analysis.head);
                for (ASTNode node : asts) {
                    temp.call(node);
                }
                Module lib = Analysis.require;
                this.analysis.addModule(lib);
                for (Function function : lib.functions) {
                    this.analysis.addFunction(function);
                }
                Map<String, Token> map = lib.variableMap;
                Intrinsics.checkNotNullExpressionValue(map, (String)"lib.variableMap");
                for (Map.Entry entry : map.entrySet()) {
                    this.analysis.addVariable((String)entry.getKey(), (Token)entry.getValue());
                }
            }
        }
        Word word = Word.NIL;
        Intrinsics.checkNotNullExpressionValue((Object)word, (String)"NIL");
        return word;
    }
}

