/*
 * Decompiled with CFR 0.152.
 */
package cn.wumoe.hime;

import cn.wumoe.hime.Format;
import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.function.RequireFun;
import cn.wumoe.hime.inter.ASTNode;
import cn.wumoe.hime.inter.Function;
import cn.wumoe.hime.inter.Module;
import cn.wumoe.hime.lexer.Lexer;
import cn.wumoe.hime.lexer.Num;
import cn.wumoe.hime.lexer.Real;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.module.AESModule;
import cn.wumoe.hime.module.BarcodeModule;
import cn.wumoe.hime.module.Base64Module;
import cn.wumoe.hime.module.CoreModule;
import cn.wumoe.hime.module.FileModule;
import cn.wumoe.hime.module.HashModule;
import cn.wumoe.hime.module.ListModule;
import cn.wumoe.hime.module.MathModule;
import cn.wumoe.hime.module.QRCodeModule;
import cn.wumoe.hime.module.RSAModule;
import cn.wumoe.hime.module.StringModule;
import cn.wumoe.hime.module.SystemModule;
import cn.wumoe.hime.module.TimeModule;
import cn.wumoe.hime.module.TypeModule;
import cn.wumoe.hime.module.http.HttpModule;
import cn.wumoe.hime.module.http.server.HttpServerModule;
import cn.wumoe.hime.module.properties.PropertiesModule;
import cn.wumoe.hime.module.socket.SocketModule;
import cn.wumoe.hime.module.thread.ThreadModule;
import cn.wumoe.hime.parser.Parser;
import cn.wumoe.hime.semantic.Analysis;
import cn.wumoe.hime.semantic.SymbolList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.List;

public class Hime {
    private final Analysis analysis;

    public Hime() {
        this.analysis = new Analysis();
        this.analysis.addFunction(new RequireFun());
        this.analysis.addModule(new CoreModule(new HimeContext(this.analysis.head)));
        this.analysis.addModule(new MathModule());
        this.analysis.addModule(new StringModule());
        this.analysis.addModule(new ListModule());
        this.analysis.addModule(new TimeModule());
        this.analysis.addModule(new SystemModule());
        this.analysis.addModule(new HashModule());
        this.analysis.addModule(new SocketModule());
        this.analysis.addModule(new HttpModule());
        this.analysis.addModule(new Base64Module());
        this.analysis.addModule(new FileModule());
        this.analysis.addModule(new HttpServerModule());
        this.analysis.addModule(new QRCodeModule());
        this.analysis.addModule(new BarcodeModule());
        this.analysis.addModule(new PropertiesModule());
        this.analysis.addModule(new AESModule());
        this.analysis.addModule(new RSAModule());
        this.analysis.addModule(new ThreadModule());
        this.analysis.addModule(new TypeModule());
    }

    public Hime(SymbolList data, HimeContext context) {
        this.analysis = new Analysis(data);
        this.analysis.addFunction(new RequireFun());
        this.analysis.addModule(new CoreModule(context));
        this.analysis.addModule(new MathModule());
        this.analysis.addModule(new StringModule());
        this.analysis.addModule(new ListModule());
        this.analysis.addModule(new TimeModule());
        this.analysis.addModule(new SystemModule());
        this.analysis.addModule(new HashModule());
        this.analysis.addModule(new SocketModule());
        this.analysis.addModule(new HttpModule());
        this.analysis.addModule(new Base64Module());
        this.analysis.addModule(new FileModule());
        this.analysis.addModule(new HttpServerModule());
        this.analysis.addModule(new QRCodeModule());
        this.analysis.addModule(new BarcodeModule());
        this.analysis.addModule(new PropertiesModule());
        this.analysis.addModule(new AESModule());
        this.analysis.addModule(new RSAModule());
        this.analysis.addModule(new ThreadModule());
        this.analysis.addModule(new TypeModule());
    }

    public void addModule(Module module2) {
        this.analysis.addModule(module2);
    }

    public void addFunction(Function function) {
        this.analysis.addFunction(function);
    }

    public void addFunction(String name, LambdaFunctionV function) {
        this.analysis.addFunction(new LambdaFunction(name, function));
    }

    public void addFunction(String name, LambdaFunctionRV function) {
        this.analysis.addFunction(new LambdaFunctionR(name, function));
    }

    public void addVariable(String key, Token value) {
        this.analysis.addVariable(key, value);
    }

    public void addVariable(String key, String value) {
        this.analysis.addVariable(key, new Word(value, Tag.STR));
    }

    public void addVariable(String key, int value) {
        this.analysis.addVariable(key, Num.toNum(value));
    }

    public void addVariable(String key, long value) {
        this.analysis.addVariable(key, Num.toNum(value));
    }

    public void addVariable(String key, float value) {
        this.analysis.addVariable(key, Real.toReal(value));
    }

    public void addVariable(String key, double value) {
        this.analysis.addVariable(key, Real.toReal(value));
    }

    public Token run(String value) {
        String s = Format.format(value);
        Lexer lex = new Lexer();
        lex.pushData(s);
        Parser parser = new Parser(lex);
        List<ASTNode> asts = parser.program();
        for (ASTNode node : asts) {
            this.analysis.call(node);
        }
        return asts.get((int)(asts.size() - 1)).tok;
    }

    public Token run(File file) throws IOException {
        String s = Format.format(Files.readString(file.toPath()));
        Lexer lex = new Lexer();
        lex.pushData(s);
        Parser parser = new Parser(lex);
        List<ASTNode> asts = parser.program();
        for (ASTNode node : asts) {
            this.analysis.call(node);
        }
        return asts.get((int)(asts.size() - 1)).tok;
    }

    static class LambdaFunction
    extends Function {
        private final LambdaFunctionV lambda;

        public LambdaFunction(String name, LambdaFunctionV lambda) {
            super(name);
            this.lambda = lambda;
        }

        @Override
        public Token call(Token[] pars) {
            this.lambda.call(pars);
            return Word.NIL;
        }
    }

    public static interface LambdaFunctionV {
        public void call(Token[] var1);
    }

    static class LambdaFunctionR
    extends Function {
        private final LambdaFunctionRV lambda;

        public LambdaFunctionR(String name, LambdaFunctionRV lambda) {
            super(name);
            this.lambda = lambda;
        }

        @Override
        public Token call(Token[] pars) {
            return this.lambda.call(pars);
        }
    }

    public static interface LambdaFunctionRV {
        public Token call(Token[] var1);
    }
}

