package cn.wumoe.hime.parser;

import cn.wumoe.hime.exceptions.HimeParserException;
import cn.wumoe.hime.exceptions.HimeParserException;
import cn.wumoe.hime.inter.ASTNode;
import cn.wumoe.hime.lexer.Lexer;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.exceptions.HimeParserException;

import java.util.*;

import static cn.wumoe.hime.lexer.Tag.DA;

/**
 * The parser parses the tokens into a ASTNode.
 */
public class Parser {
    private final List<Token> lexTokens;
    private int index;
    private Token look;

    public Parser(Lexer lex) {
        this.index = 0;
        this.lexTokens = new LinkedList<>();
        while (lex.state) {
            lexTokens.add(lex.scan());
        }
        move();
    }

    void move() {
        look = lexTokens.get(index++);
    }

    void error(final String s) throws HimeParserException {
        throw new HimeParserException(s);
    }

    public List<ASTNode> program() throws HimeParserException {
        List<ASTNode> asts = new ArrayList<>();
        Deque<ASTNode> astStack = new ArrayDeque<>();
        int state = -1;
        ASTNode temp;
        while (index < lexTokens.size()) {
            if (state == 1) {
                if (look == Word.RB) {
                    temp = ASTNode.EMPTY;
                    assert astStack.peek() != null;
                    astStack.peek().add(temp);
                    state = -1;
                    move();
                    continue;
                }
                if (look instanceof Word || look.tag == DA) {
                    if (look == Word.LB) {
                        --index;
                        lexTokens.add(index, Word.SP);
                        lexTokens.add(index, Word.STRUCTURE);
                        move();
                    }
                    temp = new ASTNode(look);
                    astStack.push(temp);
                    asts.add(temp);
                    state = -1;
                } else {
                    error("nonstandard word error");
                }
            } else if (state == 2) {
                if (look == Word.RB) {
                    temp = ASTNode.EMPTY;
                    assert astStack.peek() != null;
                    astStack.peek().add(temp);
                    state = -1;
                    move();
                    continue;
                }
                if (look instanceof Word || look.tag == DA) {
                    if (look == Word.LB) {
                        --index;
                        lexTokens.add(index, Word.SP);
                        lexTokens.add(index, Word.STRUCTURE);
                        move();
                    }
                    temp = new ASTNode(look);
                    assert astStack.peek() != null;
                    astStack.peek().add(temp);
                    astStack.push(temp);
                    state = -1;
                } else {
                    error("nonstandard word error");
                }
            } else if (look == Word.LB) {
                state = astStack.isEmpty() ? 1 : 2;
            } else if (look == Word.RB) {
                if (index >= 3 && lexTokens.get(index - 3) == Word.LB) {
                    assert astStack.peek() != null;
                    astStack.peek().tag = ASTNode.AstTag.FUNCTION;
                }
                if (!astStack.isEmpty()) {
                    astStack.pop();
                } else {
                    error("separator mismatch error");
                }
            } else if (look != Word.SP) {
                if (!astStack.isEmpty()) {
                    astStack.peek().add(new ASTNode(look));
                } else {
                    error("separator mismatch error");
                }
            }
            move();
        }
        return asts;
    }
}
