package cn.wumoe.hime.module.thread

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.lexer.Num
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import cn.wumoe.hime.toBool
import cn.wumoe.hime.toWord

class ThreadModule : Module("hime.thread") {
    override fun init(context: HimeContext) {
        addFunction(ThreadCreate())         // thread-create
        addFunction(ThreadStart())          // thread-start
        addFunction(ThreadName())           // thread-name
        addFunction(ThreadJoin())           // thread-join
        addFunction(ThreadInterrupt())      // thread-interrupt
        addFunction(ThreadIsDaemon())       // thread-daemon
        addFunction(ThreadSetDaemon())      // thread-set-daemon
        addFunction(ThreadIsInterrupted())  // thread-interrupted
        addFunction(ThreadIsAlive())        // thread-alive
        addFunction(ThreadSleep())          // thread-sleep
    }

    class ThreadSleep : Function("thread-sleep") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.isNotEmpty() && pars[0] is Num)
                Thread.sleep((pars[0] as Num).value.longValueExact())
            return Word.NIL
        }
    }

    class ThreadCreate : Function("thread-create") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty()) {
                if (pars.size == 1) {
                    val function = analysis.getFunction(pars[0].toString())
                    function.analysis = analysis
                    HimeThreadToken(Thread { function.call(arrayOf()) })
                } else {
                    val function = analysis.getFunction(pars[1].toString())
                    function.analysis = analysis
                    HimeThreadToken(Thread({ function.call(arrayOf()) }, pars[0].toString()))
                }
            } else
                Word.NIL
        }
    }

    class ThreadStart : Function("thread-start") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.isNotEmpty() && pars[0] is HimeThreadToken)
                (pars[0] as HimeThreadToken).thread.start()
            return Word.NIL
        }
    }

    class ThreadName : Function("thread-name") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty() && pars[0] is HimeThreadToken)
                (pars[0] as HimeThreadToken).thread.name.toWord()
            else
                Word.NIL
        }
    }

    class ThreadJoin : Function("thread-join") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.isNotEmpty() && pars[0] is HimeThreadToken)
                (pars[0] as HimeThreadToken).thread.join()
            return Word.NIL
        }
    }

    class ThreadInterrupt : Function("thread-interrupt") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.isNotEmpty() && pars[0] is HimeThreadToken)
                (pars[0] as HimeThreadToken).thread.interrupt()
            return Word.NIL
        }
    }

    class ThreadSetDaemon : Function("thread-set-daemon") {
        override fun call(pars: Array<out Token>): Token {
            if (pars.size >= 2 && pars[0] is HimeThreadToken && pars[1] is Word)
                (pars[0] as HimeThreadToken).thread.isDaemon = pars[1] == Word.True
            return Word.NIL
        }
    }

    class ThreadIsDaemon : Function("thread-daemon") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty() && pars[0] is HimeThreadToken)
                (pars[0] as HimeThreadToken).thread.isDaemon.toBool()
            else
                Word.NIL
        }
    }

    class ThreadIsAlive : Function("thread-alive") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty() && pars[0] is HimeThreadToken)
                (pars[0] as HimeThreadToken).thread.isAlive.toBool()
            else
                Word.NIL
        }
    }

    class ThreadIsInterrupted : Function("thread-interrupted") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty() && pars[0] is HimeThreadToken)
                (pars[0] as HimeThreadToken).thread.isInterrupted.toBool()
            else
                Word.NIL
        }
    }

}