package cn.wumoe.hime.module.socket

import cn.wumoe.hime.lexer.Tag
import cn.wumoe.hime.lexer.Token
import java.io.InputStream
import java.io.PrintWriter
import java.net.Socket
import java.util.*

class HimeSocketToken(val socket: Socket) : Token(Tag.SOCKET) {
    val inputStream: InputStream = socket.getInputStream()
    val printWriter = PrintWriter(socket.getOutputStream())

    override fun toString(): String {
        return "socket"
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other == null || javaClass != other.javaClass) return false
        val that = other as HimeSocketToken
        return socket == that.socket
    }

    override fun hashCode(): Int {
        return Objects.hash(socket)
    }
}