package cn.wumoe.hime.module.properties

import cn.wumoe.hime.lexer.Tag
import cn.wumoe.hime.lexer.Token
import java.io.File
import java.io.FileInputStream
import java.io.FileOutputStream
import java.io.InputStreamReader
import java.nio.charset.StandardCharsets
import java.util.*

open class PropertiesToken(private val path: String) : Token(Tag.PROPERTIES) {
    private var properties: Properties? = null

    init {
        load()
    }

    private fun load() {
        val file = File(path)
        if (!file.parentFile.exists() && !file.parentFile.mkdirs())
            return
        if (!file.exists())
            file.createNewFile()
        InputStreamReader(FileInputStream(path), StandardCharsets.UTF_8).use { `in` ->
            properties = Properties()
            properties!!.load(`in`)
        }
    }

    operator fun set(key: String, value: String, comments: String): String {
        properties!!.setProperty(key, value)
        FileOutputStream(path).use { fileOutputStream -> properties!!.store(fileOutputStream, comments) }
        return value
    }

    operator fun get(key: String, defaultValue: String): String {
        return properties!!.getProperty(key, defaultValue)
    }

    fun keys(): Set<Any> {
        return properties!!.keys
    }

    fun remove(key: String) {
        properties!!.remove(key)
    }
}