package cn.wumoe.hime.module.http.server

import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import cn.wumoe.hime.semantic.Analysis
import com.sun.net.httpserver.HttpExchange
import com.sun.net.httpserver.HttpHandler

class HimeHttpServerHandler(private val httpServerHandlerFunction : HimeHttpServerHandlerFunction) : HttpHandler {
    class HimeHttpServerHandlerFunction(val analysis: Analysis,
                                        path: String,
                                        val function: Function
    ) : Function("http-server-handler-$path") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty() && pars[0] is HimeHttpExchangeToken) {
                function.analysis = analysis
                function.call(arrayOf(pars[0] as HimeHttpExchangeToken))
            } else
                Word.NIL
        }
    }

    override fun handle(exchange: HttpExchange) {
        httpServerHandlerFunction.call(arrayOf(HimeHttpExchangeToken(exchange)))
    }
}