package cn.wumoe.hime.module

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.lexer.Num
import cn.wumoe.hime.lexer.Tag
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import java.text.SimpleDateFormat
import java.util.*

class TimeModule : Module("hime.time") {
    override fun init(context: HimeContext) {
        addFunction(GetTime())      // time-get
        addFunction(FormatTime())   // time-format
        addFunction(ParseTime())    // time-parse
    }

    class GetTime : Function("time-get") {
        override fun call(pars: Array<out Token>): Token {
            return Num.toNum(Date().time)
        }
    }

    class FormatTime : Function("time-format") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.size >= 2 && pars[0] is Word && pars[1] is Num) {
                val sdf = SimpleDateFormat((pars[0] as Word).lexeme)
                Word(
                    sdf.format(Date((pars[1] as Num).value.toLong())),
                    Tag.STR
                )
            } else
                Word.NIL
        }
    }

    class ParseTime : Function("time-parse") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.size >= 2 && pars[0] is Word && pars[1] is Word) {
                val sdf = SimpleDateFormat((pars[0] as Word).lexeme)
                Num.toNum(sdf.parse((pars[1] as Word).lexeme).time)
            } else
                Word.NIL
        }
    }
}