package cn.wumoe.hime.module

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import cn.wumoe.hime.toWord
import java.math.BigInteger
import java.security.MessageDigest

class HashModule : Module("hime.hash") {
    override fun init(context: HimeContext) {
        addFunction(Sha256())       // sha256
        addFunction(Sha512())       // sha512
        addFunction(Md5())          // md5
    }

    class Md5 : Function("md5") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty()) {
                BigInteger(1, MessageDigest.getInstance("MD5")
                    .digest(pars[0].toString().toByteArray())).toString(16)
                    .padStart(32, '0').toWord()
            } else
                Word.NIL
        }
    }

    class Sha256 : Function("sha256") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty()) {
                val messageDigest = MessageDigest.getInstance("SHA-256")
                messageDigest.update(pars[0].toString().toByteArray())
                val byteBuffer = messageDigest.digest()
                val strHexString = StringBuilder()
                for (b in byteBuffer) {
                    val hex = Integer.toHexString(0xff and b.toInt())
                    if (hex.length == 1) strHexString.append('0')
                    strHexString.append(hex)
                }
                strHexString.toString().toWord()
            } else
                Word.NIL
        }
    }

    class Sha512 : Function("sha512") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty()) {
                val messageDigest = MessageDigest.getInstance("SHA-512")
                messageDigest.update(pars[0].toString().toByteArray())
                val byteBuffer = messageDigest.digest()
                val strHexString = StringBuilder()
                for (b in byteBuffer) {
                    val hex = Integer.toHexString(0xff and b.toInt())
                    if (hex.length == 1) strHexString.append('0')
                    strHexString.append(hex)
                }
                strHexString.toString().toWord()
            } else
                Word.NIL
        }
    }
}