package cn.wumoe.hime.module

import cn.wumoe.hime.api.scripting.HimeContext
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.inter.Module
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import cn.wumoe.hime.toWord
import java.nio.charset.StandardCharsets
import java.util.*

class Base64Module : Module("hime.base64") {
    override fun init(context: HimeContext) {
        addFunction(Base64EncoderString())      // base64-encoder-string
        addFunction(Base64DecoderString())      // base64-decoder-string
    }

    class Base64EncoderString : Function("base64-encoder-string") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty())
                Base64.getEncoder().encodeToString(pars[0].toString().toByteArray(StandardCharsets.UTF_8)).toWord()
            else
                Word.NIL
        }
    }

    class Base64DecoderString : Function("base64-decoder-string") {
        override fun call(pars: Array<out Token>): Token {
            return if (pars.isNotEmpty())
                Base64.getDecoder().decode(pars[0].toString()).toString().toWord()
            else
                Word.NIL
        }
    }
}