package cn.wumoe.hime.lexer;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/**
 * Lexical analyzer to translate the code into tokens.
 */
public class Lexer {
    public int line = 0;
    char peek = ' ';
    final Map<String, Word> words = new HashMap<>();
    int index = 0;
    final List<char[]> data = new LinkedList<>();
    boolean keep = false;
    public boolean state;

    void reserve(final Word w) {
        words.put(w.lexeme, w);
    }

    public Lexer() {
        reserve(Word.True);
        reserve(Word.False);
        reserve(Word.ELSE);
        reserve(Word.NIL);
    }

    void read() {
        char[] chars = data.get(line);
        if (index >= chars.length) {
            line++;
            index = 0;
        }
        peek = chars[index++];
        if (line >= data.size()) {
            this.state = false;
        }
    }

    public void pushData(final String data) {
        state = true;
        StringBuilder builder = new StringBuilder();
        for (char c : data.toCharArray()) {
            if (!keep && c == '\n') {
                this.data.add(builder.toString().toCharArray());
                builder = new StringBuilder();
            } else {
                builder.append(c);
            }
        }
        if (builder.length() > 0) {
            this.data.add(builder.toString().toCharArray());
        }
    }

    public Token scan() {
        read();
        switch (peek) {
            case '(':
                return Word.LB;
            case ')':
                return Word.RB;
            case ' ':
                return Word.SP;
        }
        boolean negative = false;
        if (peek == '-' && index < data.get(line).length - 1
                && Character.isDigit(data.get(line)[index])) {
            negative = true;
            read();
        }
        if (Character.isDigit(peek)) {
            BigInteger v = BigInteger.ZERO;
            while (true) {
                if (!this.state || !Character.isDigit(peek)) {
                    // Backspace
                    --this.index;
                    break;
                }
                v = v.multiply(BigInteger.valueOf(10)).add(BigInteger.valueOf(Character.digit(peek, 10)));
                read();
            }
            if (peek != '.') {
                return negative ? new Num(v.subtract(v.multiply(BigInteger.TWO))) : new Num(v);
            }
            BigDecimal x = new BigDecimal(v.toString()), d = BigDecimal.valueOf(10);
            read();
            while (true) {
                read();
                if (!this.state || !Character.isDigit(peek)) {
                    // Backspace
                    --this.index;
                    break;
                }
                x = x.add(BigDecimal.valueOf(Character.digit(peek, 10)).divide(d, 10, RoundingMode.CEILING));
                d = d.multiply(BigDecimal.valueOf(10));
            }
            return negative ? new Real(x.subtract(x.multiply(BigDecimal.valueOf(2)))) : new Real(x);
        }

        if (peek == '\"') {
            keep = true;
            StringBuilder builder = new StringBuilder();
            boolean skip = false;
            while (true) {
                read();
                if ((index + 1 < data.get(line).length &&
                        (data.get(line)[index + 1] == '\\' || data.get(line)[index + 1] == '\"')) && peek == '\\') {
                    if (skip) {
                        skip = false;
                        builder.append("\\");
                    } else if (index + 1 < data.get(line).length && data.get(line)[index + 1] != 'n') {
                        builder.append("\\");
                    } else {
                        skip = true;
                    }
                    continue;
                } else if (!this.state || peek == '\"') {
                    if (skip) {
                        skip = false;
                        builder.append("\"");
                        continue;
                    } else {
                        break;
                    }
                }
                builder.append(peek);
            }
            keep = false;
            return new Word(builder.toString(), Tag.STR);
        }

        if (peek != ' ' && peek != '(' && peek != ')') {
            StringBuilder builder = new StringBuilder();
            while (true) {
                if (!this.state || peek == ' ' || peek == ')') {
                    // Backspace
                    --this.index;
                    break;
                }
                builder.append(peek);
                read();
            }
            String s = builder.toString();
            if (words.containsKey(s))
                return words.get(s);
            return new Word(builder.toString(), Tag.ID);
        }
        return new Token(peek);
    }
}