package cn.wumoe.hime.inter;

import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.api.scripting.HimeContext;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class Module extends Token {
    public final String path;
    public final List<Function> functions;
    public final Map<String, Token> variableMap;

    public Module(String path) {
        super(Tag.LIBRARY);
        this.path = path;
        this.functions = new CopyOnWriteArrayList<>();
        this.variableMap = new ConcurrentHashMap<>();
        this.init(new HimeContext());
    }

    public Module(String path, HimeContext context) {
        super(Tag.LIBRARY);
        this.path = path;
        this.functions = new CopyOnWriteArrayList<>();
        this.variableMap = new ConcurrentHashMap<>();
        this.init(context);
    }


    public abstract void init(HimeContext context);

    public void addFunction(Function f) {
        functions.add(f);
    }

    public void addVariable(String key, Token token) {
        this.variableMap.put(key, token);
    }

    public int size() {
        return functions.size();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Module module = (Module) o;
        return path.equals(module.path) && functions.equals(module.functions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), path, functions);
    }
}
