package cn.wumoe.hime.inter;

import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.semantic.Analysis;
import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.semantic.Analysis;
import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;
import cn.wumoe.hime.lexer.Word;
import cn.wumoe.hime.semantic.Analysis;

import java.util.List;
import java.util.Objects;

public abstract class Function extends Token {
    public final String name;
    public ASTNode ast;
    public Analysis analysis;
    public final boolean keep;
    public List<Word> parameterList;

    public Function(String name, boolean keep) {
        super(Tag.FUNCTION);
        this.name = name;
        this.keep = keep;
    }

    public Function(String name) {
        super(Tag.FUNCTION);
        this.name = name;
        this.keep = false;
    }

    public abstract Token call(Token[] pars);

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Function function = (Function) o;
        return name.equals(function.name) &&
                ast.equals(function.ast) &&
                parameterList.equals(function.parameterList);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, ast, parameterList);
    }
}
