package cn.wumoe.hime.inter;

import cn.wumoe.hime.lexer.Tag;
import cn.wumoe.hime.lexer.Token;

import java.util.*;

public class ASTNode extends Token {
    public final static ASTNode EMPTY = new ASTNode(new Token(' '));
    public enum AstTag {
        FUNCTION, BASIC
    }
    public Token tok;
    public AstTag tag = AstTag.BASIC;
    public final List<ASTNode> prev;

    public ASTNode(Token tok) {
        super(Tag.AST);
        this.tok = tok;
        prev = new LinkedList<>();
    }

    public ASTNode(Token tok, List<ASTNode> prev) {
        super(Tag.AST);
        this.tok = tok;
        this.prev = prev;
    }

    public ASTNode copy() {
        List<ASTNode> list = new LinkedList<>();
        for (ASTNode ast : prev) {
            list.add(ast.copy());
        }
        ASTNode newAst = new ASTNode(tok, list);
        newAst.tag = tag;
        return newAst;
    }

    public void add(ASTNode node) {
        this.prev.add(node);
    }

    public ASTNode get(int i) {
        return prev.get(i);
    }

    public void remove(ASTNode node) {
        prev.remove(node);
    }
    public void remove(int index) {
        prev.remove(index);
    }

    public void clear() {
        prev.clear();
    }

    public int size() {
        return prev.size();
    }

    public ListIterator<ASTNode> listIterator() {
        return prev.listIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ASTNode astNode = (ASTNode) o;
        return tok.equals(astNode.tok) && prev.equals(astNode.prev);
    }

    @Override
    public int hashCode() {
        return Objects.hash(tok, prev);
    }

    @Override
    public String toString() {
        return "{tok=" + tok +
                ", prev=" + Arrays.toString(prev.toArray()) +
                '}';
    }
}
