package cn.wumoe.hime.gui;

import cn.wumoe.hime.Config;
import cn.wumoe.hime.Hime;
import com.tulskiy.keymaster.common.Provider;
import org.fife.ui.rsyntaxtextarea.*;
import org.fife.ui.rsyntaxtextarea.folding.FoldParserManager;
import org.fife.ui.rtextarea.RTextScrollPane;

import javax.swing.*;
import java.awt.*;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class GUI extends JFrame {
    public static JEditorPane result;

    public static void main(String[] args) {
        Config.GUI = true;
        JFrame jFrame = new JFrame("Press Ctrl + R to execute.");
        int inset = 100;
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int width = (screenSize.width - inset * 5) / 2;
        int height = screenSize.height - inset * 2;

        JPanel panel = new JPanel(new FlowLayout());

        RSyntaxTextArea textArea = new RSyntaxTextArea();
        AbstractTokenMakerFactory atmf = (AbstractTokenMakerFactory) TokenMakerFactory.getDefaultInstance();
        atmf.putMapping("text/hime", "cn.wumoe.hime.gui.HimeTokenMaker");
        FoldParserManager.get().addFoldParserMapping("text/hime", new HimeFoldParser());
        textArea.setSyntaxEditingStyle("text/hime");
        textArea.setCodeFoldingEnabled(true);
        textArea.setAntiAliasingEnabled(true);

        SyntaxScheme scheme = textArea.getSyntaxScheme();
        scheme.getStyle(Token.FUNCTION).foreground = Color.blue;
        textArea.revalidate();

        textArea.setBounds(0, 0, width - (width / 12), height - (height / 3));
        textArea.setPreferredSize(new Dimension(width - (width / 12), height - (height / 3)));
        textArea.setFont(new Font(textArea.getFont().getName(), textArea.getFont().getStyle(), (height / 50)));
        textArea.addKeyListener(new KeyAdapter() {
            @Override
            public void keyTyped(KeyEvent e) {
                super.keyTyped(e);
                String[] ss = textArea.getText().split("\n", -1);
                int size = ss.length;
                int widthMax = -1;
                for (String s : ss)
                    widthMax = Math.max(widthMax, s.length());
                textArea.setPreferredSize(new Dimension(Math.max(width - (width / 12), (width / 63) * widthMax), Math.max(height - (height / 3), ((height / 50) + (height / 190)) * size)));
            }
        });

        RTextScrollPane sp = new RTextScrollPane(textArea);
        sp.setPreferredSize(new Dimension(width, height - (height / 3)));
        panel.add(sp);

        result = new JEditorPane();
        result.setEditable(false);
        result.setBounds(0, height - (height / 3), width, (height / 3) - 20);
        JScrollPane resultJsp = new JScrollPane(result, JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
        resultJsp.setPreferredSize(new Dimension(width, (height / 3) - 20));
        result.setFont(new Font(result.getFont().getName(), result.getFont().getStyle(), (height / 50)));
        panel.add(resultJsp);

        jFrame.setResizable(false);
        jFrame.add(panel);
        jFrame.setBounds(inset, inset, width + 18, height + 30);
        jFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        jFrame.setVisible(true);
        Provider provider = Provider.getCurrentProvider(true);
        provider.register(KeyStroke.getKeyStroke(KeyEvent.VK_R, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()),
                x -> {
                    result.setText("");
                    Hime hime = new Hime();
                    hime.run(textArea.getText());
                });
    }
}