package cn.wumoe.hime.function

import cn.wumoe.hime.Config
import cn.wumoe.hime.Format.format
import cn.wumoe.hime.exceptions.HimeModuleException
import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.lexer.Lexer
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import cn.wumoe.hime.parser.Parser
import cn.wumoe.hime.semantic.Analysis
import java.io.File
import java.nio.file.Files

class RequireFun : Function("require") {
    override fun call(pars: Array<out Token>): Token {
        if (pars.isNotEmpty()) {
            val path = pars[0].toString()
            if (analysis.containsModule(path)) {
                val module = analysis.getModule(path)
                if (module != null) {
                    for (func in module.functions) {
                        analysis.addFunction(func)
                    }
                    for (vars in module.variableMap)
                        analysis.addVariable(vars.key, vars.value)
                } else
                    throw HimeModuleException("Module $path does not exist!!!")
            }
            val file = File("./" + path.replace(".", "/") + ".hime")
            if (file.exists()) {
                val lex = Lexer()
                lex.pushData(format(Files.readString(file.toPath())))
                val parser = Parser(lex)
                val asts = parser.program()
                val temp = Analysis(analysis.head)
                for (node in asts)
                    temp.call(node)
                val lib = Analysis.require
                analysis.addModule(lib)
                for (func in lib.functions)
                    analysis.addFunction(func)
                for (vars in lib.variableMap)
                    analysis.addVariable(vars.key, vars.value)
            }
        }
        return Word.NIL
    }
}