package cn.wumoe.hime.function

import cn.wumoe.hime.inter.Function
import cn.wumoe.hime.inter.ASTNode
import cn.wumoe.hime.lexer.Token
import cn.wumoe.hime.lexer.Word
import cn.wumoe.hime.semantic.Analysis

class CustomFun(
    private val als: Analysis,
    name: String,
    private val functionAst: Array<ASTNode?>,
    val prs: Array<String?>
) : Function(name) {
    override fun call(pars: Array<out Token>): Token {
        return if (pars.size >= prs.size) {
            val temp = als.copy()
            for (i in pars.indices)
                temp.addVariable(prs[i], pars[i])
            var ast = functionAst[0]!!.copy()
            for (i in 1 until functionAst.size) {
                temp.call(ast)
                ast = functionAst[i]!!.copy()
            }
            temp.call(ast)
            for (i in pars.indices)
                als.removeVariable(prs[i])
            ast.tok
        } else
            Word.NIL
    }
}