package cn.workde.core.sms.service.impl;

import cn.workde.core.sms.properties.AlismsProperties;
import cn.workde.core.sms.properties.WorkdeSmsProperties;
import cn.workde.core.sms.service.IAliyunService;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author zhujingang
 * @date 2019/9/23 9:08 AM
 */
public class AliyunServiceImpl implements IAliyunService {

	@Autowired
	private WorkdeSmsProperties workdeSmsProperties;

	@Override
	public IAcsClient getAcsClient() {

		AlismsProperties alismsProperties = workdeSmsProperties.getAlisms();
		//初始化acsClient,暂不支持region化
		IClientProfile profile = DefaultProfile.getProfile(alismsProperties.getRegionId(), alismsProperties.getAccessKey(), alismsProperties.getSecretKey());
		DefaultProfile.addEndpoint(alismsProperties.getRegionId(), alismsProperties.getProduct(), alismsProperties.getDomain());
		IAcsClient acsClient = new DefaultAcsClient(profile);
		return acsClient;
	}
}
