/*
 * Decompiled with CFR 0.152.
 */
package cn.workde.core.secure.config;

import cn.workde.core.secure.aspect.AuthAspect;
import cn.workde.core.secure.interceptor.TokenInterceptor;
import cn.workde.core.secure.properties.WorkdeSecureProperties;
import cn.workde.core.secure.registry.SecureRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Order
@Configuration
@EnableConfigurationProperties(value={WorkdeSecureProperties.class})
public class SecureConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(SecureConfiguration.class);
    private final SecureRegistry secureRegistry;
    private final WorkdeSecureProperties workdeSecureProperties;

    public void addInterceptors(InterceptorRegistry registry) {
        log.info("secure enable {}", (Object)this.secureRegistry.isEnable());
        if (this.secureRegistry.isEnable()) {
            registry.addInterceptor((HandlerInterceptor)new TokenInterceptor()).excludePathPatterns(this.secureRegistry.getExcludePatterns()).excludePathPatterns(this.secureRegistry.getDefaultExcludePatterns()).excludePathPatterns(this.workdeSecureProperties.getSkip());
        }
    }

    @Bean
    public AuthAspect authAspect() {
        return new AuthAspect();
    }

    public SecureConfiguration(SecureRegistry secureRegistry, WorkdeSecureProperties workdeSecureProperties) {
        this.secureRegistry = secureRegistry;
        this.workdeSecureProperties = workdeSecureProperties;
    }
}

