/*
 * Decompiled with CFR 0.152.
 */
package cn.workde.core.secure.aspect;

import cn.hutool.core.util.StrUtil;
import cn.workde.core.base.exception.ForbiddenException;
import cn.workde.core.base.result.Result;
import cn.workde.core.base.utils.ClassUtils;
import cn.workde.core.secure.annotation.PreAuth;
import cn.workde.core.secure.auth.AuthFun;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.core.MethodParameter;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class AuthAspect
implements ApplicationContextAware {
    private static final ExpressionParser SPEL_PARSER = new SpelExpressionParser();
    private ApplicationContext applicationContext;

    @Around(value="@annotation(cn.workde.core.secure.annotation.PreAuth) || @within(cn.workde.core.secure.annotation.PreAuth)")
    public Object preAuth(ProceedingJoinPoint point) throws Throwable {
        if (this.handleAuth(point)) {
            return point.proceed();
        }
        throw new ForbiddenException(Result.forbidden().getMsg());
    }

    private boolean handleAuth(ProceedingJoinPoint point) {
        MethodSignature ms = (MethodSignature)point.getSignature();
        Method method = ms.getMethod();
        PreAuth preAuth = (PreAuth)ClassUtils.getAnnotation((Method)method, PreAuth.class);
        String condition = preAuth.value();
        if (StrUtil.isNotBlank((CharSequence)condition)) {
            Expression expression = SPEL_PARSER.parseExpression(condition);
            Object[] args = point.getArgs();
            StandardEvaluationContext context = this.getEvaluationContext(method, args);
            return (Boolean)expression.getValue((EvaluationContext)context, Boolean.class);
        }
        return false;
    }

    private StandardEvaluationContext getEvaluationContext(Method method, Object[] args) {
        StandardEvaluationContext context = new StandardEvaluationContext((Object)new AuthFun());
        context.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)this.applicationContext));
        for (int i = 0; i < args.length; ++i) {
            MethodParameter methodParam = ClassUtils.getMethodParameter((Method)method, (int)i);
            context.setVariable(methodParam.getParameterName(), args[i]);
        }
        return context;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

