/*
 * Decompiled with CFR 0.152.
 */
package cn.workde.core.boot.json;

import cn.workde.core.base.utils.ObjectUtils;
import cn.workde.core.base.utils.jackson.JacksonObjectMapper;
import cn.workde.core.boot.annotation.SerializeField;
import cn.workde.core.boot.json.JacksonJsonFilter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ser.FilterProvider;

public class JsonSerializer {
    private ObjectMapper mapper = new JacksonObjectMapper();
    JacksonJsonFilter jacksonFilter = new JacksonJsonFilter();

    public void filter(Class<?> clazz, String include, String filter) {
        if (clazz == null) {
            return;
        }
        if (!ObjectUtils.isEmpty((Object)include)) {
            this.jacksonFilter.include(clazz, include.split(","));
        }
        if (!ObjectUtils.isEmpty((Object)filter)) {
            this.jacksonFilter.filter(clazz, filter.split(","));
        }
        this.mapper.addMixIn(clazz, ((Object)((Object)this.jacksonFilter)).getClass());
    }

    public String toJson(Object object) throws JsonProcessingException {
        this.mapper.setFilterProvider((FilterProvider)this.jacksonFilter);
        return this.mapper.writeValueAsString(object);
    }

    public void filter(SerializeField serializeField) {
        this.filter(serializeField.clazz(), serializeField.includes(), serializeField.excludes());
    }
}

