/*
 * Decompiled with CFR 0.152.
 */
package cn.workde.core.boot.json;

import cn.workde.core.boot.annotation.MoreSerializeField;
import cn.workde.core.boot.annotation.SerializeField;
import cn.workde.core.boot.json.JsonSerializer;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class JsonReturnHandler
implements HandlerMethodReturnValueHandler {
    private static final Logger log = LoggerFactory.getLogger(JsonReturnHandler.class);

    public boolean supportsReturnType(MethodParameter methodParameter) {
        boolean hasJsonAnnotation = methodParameter.hasMethodAnnotation(SerializeField.class) || methodParameter.hasMethodAnnotation(MoreSerializeField.class);
        return hasJsonAnnotation;
    }

    public void handleReturnValue(Object returnValue, MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest) throws Exception {
        modelAndViewContainer.setRequestHandled(true);
        HttpServletResponse response = (HttpServletResponse)nativeWebRequest.getNativeResponse(HttpServletResponse.class);
        Annotation[] annos = methodParameter.getMethodAnnotations();
        JsonSerializer jsonSerializer = new JsonSerializer();
        Arrays.asList(annos).forEach(a -> {
            if (a instanceof SerializeField) {
                SerializeField serializeField2 = (SerializeField)a;
                jsonSerializer.filter(serializeField2);
            } else if (a instanceof MoreSerializeField) {
                MoreSerializeField moreSerializeField = (MoreSerializeField)a;
                Arrays.asList(moreSerializeField.value()).forEach(serializeField -> jsonSerializer.filter((SerializeField)serializeField));
            }
        });
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json;charset=UTF-8");
        String json = jsonSerializer.toJson(returnValue);
        response.getWriter().write(json);
    }
}

