/*
 * Decompiled with CFR 0.152.
 */
package cn.workde.core.boot.config;

import cn.workde.core.boot.config.WorkdeAutoConfiguration;
import cn.workde.core.boot.json.JsonReturnHandler;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.method.annotation.DeferredResultMethodReturnValueHandler;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Configuration
@AutoConfigureAfter(value={WorkdeAutoConfiguration.class})
public class WorkdeReturnConfiguration {
    @Autowired
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;

    @Bean
    public HandlerMethodReturnValueHandler jsonReturnHandler() {
        return new JsonReturnHandler();
    }

    @PostConstruct
    public void init() {
        ArrayList<HandlerMethodReturnValueHandler> originalHandlers = new ArrayList<HandlerMethodReturnValueHandler>(this.requestMappingHandlerAdapter.getReturnValueHandlers());
        int deferredPos = this.obtainValueHandlerPosition(originalHandlers, DeferredResultMethodReturnValueHandler.class);
        originalHandlers.add(deferredPos + 1, this.jsonReturnHandler());
        this.requestMappingHandlerAdapter.setReturnValueHandlers(originalHandlers);
    }

    private int obtainValueHandlerPosition(List<HandlerMethodReturnValueHandler> originalHandlers, Class<?> handlerClass) {
        for (int i = 0; i < originalHandlers.size(); ++i) {
            HandlerMethodReturnValueHandler valueHandler = originalHandlers.get(i);
            if (!handlerClass.isAssignableFrom(valueHandler.getClass())) continue;
            return i;
        }
        return -1;
    }
}

